/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.aadhaar.webservice.client;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.egov.infra.aadhaar.webservice.contract.AadhaarInfo;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.w3c.dom.Node;

@Service
public class AadhaarInfoServiceClient {
    @Value(value="${aadhaar.info.ws.namespace}")
    private String aadharWSDLNamespace;
    @Value(value="${aadhaar.wsdl.url}")
    private String aadharWSDLUrl;
    @Value(value="${aadhaar.info.ws.method}")
    private String aadharWSDLMethod;
    @Value(value="${aadhaar.info.ws.client.impl.class.fqn}")
    private String clientImplClassFQN;

    public AadhaarInfo getAadhaarInfo(String uid) {
        try {
            SOAPConnection soapConnection = SOAPConnectionFactory.newInstance().createConnection();
            AadhaarInfo aahaarInfo = this.retriveAadhaarInfo(soapConnection.call(this.soapRequest(uid), (Object)this.aadharWSDLUrl));
            soapConnection.close();
            return aahaarInfo;
        }
        catch (SOAPException e) {
            throw new ApplicationRuntimeException("Error occurred while getting Aadhaar Info", e);
        }
    }

    private SOAPMessage soapRequest(String uid) {
        try {
            SOAPMessage soapMessage = MessageFactory.newInstance().createMessage();
            SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
            soapEnvelope.addNamespaceDeclaration("end", this.aadharWSDLNamespace);
            soapEnvelope.getBody().addChildElement(this.aadharWSDLMethod, "end").addChildElement("arg0").addTextNode(uid);
            soapMessage.saveChanges();
            return soapMessage;
        }
        catch (SOAPException e) {
            throw new ApplicationRuntimeException("Error occurred while preparing Aadhaar Info request", e);
        }
    }

    private AadhaarInfo retriveAadhaarInfo(SOAPMessage soapResponseMessage) {
        try {
            Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{Class.forName(this.clientImplClassFQN)}).createUnmarshaller();
            return (AadhaarInfo)unmarshaller.unmarshal((Node)soapResponseMessage.getSOAPBody().extractContentAsDocument());
        }
        catch (ClassNotFoundException | JAXBException | SOAPException e) {
            throw new ApplicationRuntimeException("Error occurred while converting Aadhaar Info", e);
        }
    }
}

