/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.spring.handler;

import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.egov.infra.config.core.GlobalSettings;
import org.egov.infra.web.support.propertyeditor.JodaDateTimeEditor;
import org.joda.time.DateTime;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.InitBinder;

@ControllerAdvice
public class GlobalInitBinderHandler {
    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)new SimpleDateFormat(GlobalSettings.defaultDatePattern()), true));
        binder.registerCustomEditor(DateTime.class, (PropertyEditor)new JodaDateTimeEditor(GlobalSettings.defaultDatePattern(), true));
        binder.registerCustomEditor(String.class, (PropertyEditor)new StringTrimmerEditor(true));
        binder.setDisallowedFields(new String[]{"id"});
    }
}

