/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.scheduler.quartz;

import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.entity.CityPreferences;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.scheduler.GenericJob;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;

public abstract class AbstractQuartzJob
extends QuartzJobBean
implements GenericJob {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractQuartzJob.class);
    @Resource(name="cities")
    private transient List<String> cities;
    @Autowired
    private transient CityService cityService;
    @Autowired
    private transient UserService userService;
    private String userName;
    private String moduleName;
    private boolean cityDataRequired;

    protected void executeInternal(JobExecutionContext jobCtx) throws JobExecutionException {
        try {
            MDC.put((String)"appname", (String)String.format("%s-%s", this.moduleName, jobCtx.getJobDetail().getKey().getName()));
            for (String tenant : this.cities) {
                MDC.put((String)"ulbcode", (String)tenant);
                this.prepareThreadLocal(tenant);
                this.executeJob();
            }
        }
        catch (Exception ex) {
            LOGGER.error("Unable to complete execution Scheduler ", (Throwable)ex);
            throw new JobExecutionException("Unable to execute batch job Scheduler", (Throwable)ex, false);
        }
        finally {
            ApplicationThreadLocals.clearValues();
            MDC.clear();
        }
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setUserName(String userName) {
        this.userName = (String)StringUtils.defaultIfBlank((CharSequence)userName, (CharSequence)"egovernments");
    }

    public void setCityDataRequired(boolean cityDataRequired) {
        this.cityDataRequired = cityDataRequired;
    }

    private void prepareThreadLocal(String tenant) {
        ApplicationThreadLocals.setTenantID(tenant);
        ApplicationThreadLocals.setUserId(this.userService.getUserByUsername(this.userName).getId());
        if (this.cityDataRequired) {
            City city = this.cityService.findAll().get(0);
            ApplicationThreadLocals.setCityCode(city.getCode());
            ApplicationThreadLocals.setCityName(city.getName());
            CityPreferences cityPreferences = city.getPreferences();
            if (cityPreferences != null) {
                ApplicationThreadLocals.setMunicipalityName(cityPreferences.getMunicipalityName());
            } else {
                LOGGER.warn("City preferences not set for {}", (Object)city.getName());
            }
            ApplicationThreadLocals.setDomainName(city.getDomainURL());
        }
    }
}

