/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.microservice.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.RoleService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.config.properties.ApplicationProperties;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.microservice.contract.CreateUserRequest;
import org.egov.infra.microservice.contract.RequestInfoWrapper;
import org.egov.infra.microservice.contract.Task;
import org.egov.infra.microservice.contract.TaskResponse;
import org.egov.infra.microservice.contract.UserDetailResponse;
import org.egov.infra.microservice.contract.UserRequest;
import org.egov.infra.microservice.models.RequestInfo;
import org.egov.infra.microservice.models.RoleInfo;
import org.egov.infra.microservice.models.UserInfo;
import org.egov.infra.persistence.entity.enums.UserType;
import org.egov.infra.security.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class MicroserviceUtils {
    private static final Logger LOGGER = Logger.getLogger(MicroserviceUtils.class);
    private static final String CLIENT_ID = "client.id";
    private static final String ROLE_CITIZEN = "CITIZEN";
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private Environment environment;
    @Autowired
    private RoleService roleService;
    @Autowired
    private ApplicationProperties applicationProperties;

    public RequestInfo createRequestInfo() {
        RequestInfo requestInfo = new RequestInfo();
        requestInfo.setApiId("apiId");
        requestInfo.setVer("ver");
        requestInfo.setTs(new Date());
        requestInfo.setUserInfo(this.getUserInfo());
        return requestInfo;
    }

    public UserInfo getUserInfo() {
        User user = this.securityUtils.getCurrentUser();
        ArrayList<RoleInfo> roles = new ArrayList<RoleInfo>();
        user.getRoles().forEach(authority -> roles.add(new RoleInfo(authority.getName())));
        return new UserInfo(roles, user.getId(), user.getUsername(), user.getName(), user.getEmailId(), user.getMobileNumber(), user.getType().toString(), this.getTanentId());
    }

    public String getTanentId() {
        String clientId = this.environment.getProperty(CLIENT_ID);
        String tenantId = ApplicationThreadLocals.getTenantID();
        if (StringUtils.isNotBlank((String)clientId)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(clientId).append('.').append(tenantId);
            tenantId = stringBuilder.toString();
        }
        return tenantId;
    }

    public void createUserMicroservice(User user) {
        String createUserServiceUrl = this.applicationProperties.getCreateUserServiceUrl();
        if (StringUtils.isNotBlank((String)createUserServiceUrl)) {
            if (user.getRoles().isEmpty() && user.getType().equals((Object)UserType.CITIZEN)) {
                user.addRole(this.roleService.getRoleByName(ROLE_CITIZEN));
            }
            CreateUserRequest createUserRequest = new CreateUserRequest();
            UserRequest userRequest = new UserRequest(user, this.getTanentId());
            createUserRequest.setUserRequest(userRequest);
            createUserRequest.setRequestInfo(this.createRequestInfo());
            RestTemplate restTemplate = new RestTemplate();
            try {
                restTemplate.postForObject(createUserServiceUrl, (Object)createUserRequest, UserDetailResponse.class, new Object[0]);
            }
            catch (Exception e) {
                String errMsg = "Exception while creating User in microservice ";
                LOGGER.error((Object)"Exception while creating User in microservice ", (Throwable)e);
                throw new ApplicationRuntimeException("Exception while creating User in microservice ", e);
            }
        }
    }

    public List<Task> getTasks() {
        String workflowUrl = this.applicationProperties.getServicesWorkflowUrl();
        List<Task> tasks = new ArrayList<Task>();
        if (StringUtils.isNotBlank((String)workflowUrl)) {
            RestTemplate restTemplate = new RestTemplate();
            TaskResponse tresp = null;
            try {
                RequestInfo createRequestInfo = this.createRequestInfo();
                RequestInfoWrapper requestInfo = new RequestInfoWrapper();
                requestInfo.setRequestInfo(createRequestInfo);
                tresp = (TaskResponse)restTemplate.postForObject(workflowUrl, (Object)requestInfo, TaskResponse.class, new Object[0]);
                tasks = tresp.getTasks();
            }
            catch (Exception e) {
                String errMsg = "Exception while getting inbox items from microservice ";
                throw new ApplicationRuntimeException("Exception while getting inbox items from microservice ", e);
            }
        }
        return tasks;
    }
}

