/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.messaging.email;

import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.util.ByteArrayDataSource;
import org.egov.infra.config.properties.ApplicationProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.MailParseException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;

@Service
public class EmailService {
    @Autowired
    private JavaMailSenderImpl mailSender;
    @Autowired
    private ApplicationProperties applicationProperties;

    public boolean sendMail(String toEmail, String subject, String mailBody) {
        boolean isSent = false;
        if (this.applicationProperties.emailEnabled()) {
            SimpleMailMessage mailMessage = new SimpleMailMessage();
            mailMessage.setTo(toEmail);
            mailMessage.setSubject(subject);
            mailMessage.setText(mailBody);
            this.mailSender.send(mailMessage);
            isSent = true;
        }
        return isSent;
    }

    public boolean sendMailWithAttachment(String toEmail, String subject, String mailBody, String fileType, String fileName, Object attachment) {
        boolean isSent = false;
        if (this.applicationProperties.emailEnabled()) {
            MimeMessage message = this.mailSender.createMimeMessage();
            try {
                MimeMessageHelper mimeMessageHelper = new MimeMessageHelper(message, true);
                mimeMessageHelper.setTo(toEmail);
                mimeMessageHelper.setSubject(subject);
                mimeMessageHelper.setText(mailBody);
                ByteArrayDataSource source = new ByteArrayDataSource((byte[])attachment, fileType);
                mimeMessageHelper.addAttachment(fileName, (DataSource)source);
            }
            catch (MessagingException e) {
                throw new MailParseException((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new MailParseException((Throwable)e);
            }
            this.mailSender.send(message);
        }
        return isSent;
    }
}

