/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.elasticsearch.entity;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.egov.infra.elasticsearch.entity.enums.ApprovalStatus;
import org.egov.infra.elasticsearch.entity.enums.ClosureStatus;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.ValidatorUtils;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EG_APPLICATIONINDEX")
@SequenceGenerator(name="SEQ_EG_APPLICATIONINDEX", sequenceName="SEQ_EG_APPLICATIONINDEX", allocationSize=1)
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="version")
public class ApplicationIndex
extends AbstractAuditable {
    public static final String SEQ_APPLICATIONINDEX = "SEQ_EG_APPLICATIONINDEX";
    private static final long serialVersionUID = -5846090185417446039L;
    @Id
    @GeneratedValue(generator="SEQ_EG_APPLICATIONINDEX", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    @Length(max=50)
    private String moduleName;
    @NotNull
    @Length(max=50)
    private String applicationNumber;
    @NotNull
    private Date applicationDate;
    @NotNull
    @Length(max=150)
    private String applicationType;
    @NotNull
    @Length(max=250)
    private String applicantName;
    @Length(max=250)
    private String applicantAddress;
    private Date disposalDate;
    @NotNull
    @Length(max=50)
    private String status;
    @NotNull
    @Length(max=250)
    private String url;
    @Length(max=50)
    private String consumerCode;
    @Length(min=10, max=50)
    private String mobileNumber;
    private String ownerName;
    @Length(min=10, max=50)
    private String aadharNumber;
    private Integer elapsedDays;
    @Length(max=50)
    @Enumerated(value=EnumType.STRING)
    private ClosureStatus closed;
    @Length(max=50)
    @Enumerated(value=EnumType.STRING)
    private ApprovalStatus approved;
    @Length(max=50)
    private String channel;
    @Length(max=4)
    private String cityCode;
    @NotNull
    @Length(max=250)
    private String cityName;
    @Length(max=50)
    private String cityGrade;
    @Length(max=250)
    private String districtName;
    @Length(max=50)
    private String regionName;
    private Integer isClosed;
    private Integer sla;
    private Integer slaGap;

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        ValidatorUtils.assertNotNull(moduleName, "Module Name is mandatory");
        this.moduleName = moduleName;
    }

    public String getApplicationNumber() {
        return this.applicationNumber;
    }

    public void setApplicationNumber(String applicationNumber) {
        ValidatorUtils.assertNotNull(applicationNumber, "Application Number is mandatory");
        this.applicationNumber = applicationNumber;
    }

    public Date getApplicationDate() {
        return this.applicationDate;
    }

    public void setApplicationDate(Date applicationDate) {
        ValidatorUtils.assertNotNull(applicationDate, "Application Date is mandatory");
        this.applicationDate = applicationDate;
    }

    public String getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(String applicationType) {
        ValidatorUtils.assertNotNull(applicationType, "Application Type is mandatory");
        this.applicationType = applicationType;
    }

    public String getApplicantName() {
        return this.applicantName;
    }

    public void setApplicantName(String applicantName) {
        ValidatorUtils.assertNotNull(applicantName, "Applicant Name is mandatory");
        this.applicantName = applicantName;
    }

    public String getApplicantAddress() {
        return this.applicantAddress;
    }

    public void setApplicantAddress(String applicantAddress) {
        this.applicantAddress = applicantAddress;
    }

    public Date getDisposalDate() {
        if (this.closed.name().equals(ClosureStatus.YES.toString())) {
            this.disposalDate = new Date();
        } else if (this.closed.name().equals(ClosureStatus.NO.toString())) {
            this.disposalDate = null;
        }
        return this.disposalDate;
    }

    public void setDisposalDate(Date disposalDate) {
        this.disposalDate = disposalDate;
    }

    public String getCityName() {
        return this.cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getDistrictName() {
        return this.districtName;
    }

    public void setDistrictName(String districtName) {
        this.districtName = districtName;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        ValidatorUtils.assertNotNull(status, "Application Status is mandatory");
        this.status = status;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        ValidatorUtils.assertNotNull(url, "URL is mandatory");
        this.url = url;
    }

    public String getConsumerCode() {
        return this.consumerCode;
    }

    public void setConsumerCode(String consumerCode) {
        this.consumerCode = consumerCode;
    }

    public String getMobileNumber() {
        return this.mobileNumber;
    }

    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getAadharNumber() {
        return this.aadharNumber;
    }

    public void setAadharNumber(String aadharNumber) {
        this.aadharNumber = aadharNumber;
    }

    public Integer getElapsedDays() {
        if (this.closed.name().equals(ClosureStatus.YES.toString())) {
            this.elapsedDays = DateUtils.daysBetween(this.getCreatedDate(), this.disposalDate);
        } else if (this.closed.name().equals(ClosureStatus.NO.toString())) {
            this.elapsedDays = DateUtils.daysBetween(this.getCreatedDate(), new Date());
        }
        return this.elapsedDays;
    }

    public void setElapsedDays(Integer elapsedDays) {
        this.elapsedDays = elapsedDays;
    }

    public ClosureStatus getClosed() {
        return this.closed;
    }

    public void setClosed(ClosureStatus closed) {
        this.closed = closed;
        if (this.closed.toString().equals(ClosureStatus.YES.toString())) {
            this.setIsClosed(1);
        } else {
            this.setIsClosed(0);
        }
    }

    public ApprovalStatus getApproved() {
        return this.approved;
    }

    public void setApproved(ApprovalStatus approved) {
        this.approved = approved;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        ValidatorUtils.assertNotNull(channel, "Channel is mandatory");
        this.channel = channel;
    }

    public String getCityCode() {
        return this.cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public Integer getIsClosed() {
        return this.isClosed;
    }

    public void setIsClosed(Integer isClosed) {
        this.isClosed = isClosed;
    }

    public String getCityGrade() {
        return this.cityGrade;
    }

    public void setCityGrade(String cityGrade) {
        this.cityGrade = cityGrade;
    }

    public Integer getSla() {
        return this.sla;
    }

    public void setSla(Integer sla) {
        this.sla = sla;
    }

    public Integer getSlaGap() {
        return this.slaGap;
    }

    public void setSlaGap(Integer slaGap) {
        this.slaGap = slaGap;
    }

    public static final class Builder {
        private String moduleName;
        private String applicationNumber;
        private Date applicationDate;
        private String applicationType;
        private String applicantName;
        private String applicantAddress;
        private Date disposalDate;
        private String status;
        private String url;
        private String consumerCode;
        private String mobileNumber;
        private String ownerName;
        private String aadharNumber;
        private Integer elapsedDays = 0;
        private ClosureStatus closed;
        private ApprovalStatus approved;
        private String channel;
        private Integer sla = 0;

        private Builder() {
        }

        public Builder withModuleName(String moduleName) {
            this.moduleName = moduleName;
            return this;
        }

        public Builder withApplicationNumber(String applicationNumber) {
            this.applicationNumber = applicationNumber;
            return this;
        }

        public Builder withApplicationDate(Date applicationDate) {
            this.applicationDate = applicationDate;
            return this;
        }

        public Builder withApplicationType(String applicationType) {
            this.applicationType = applicationType;
            return this;
        }

        public Builder withApplicantName(String applicantName) {
            this.applicantName = applicantName;
            return this;
        }

        public Builder withApplicantAddress(String applicantAddress) {
            this.applicantAddress = applicantAddress;
            return this;
        }

        public Builder withDisposalDate(Date disposalDate) {
            this.disposalDate = disposalDate;
            return this;
        }

        public Builder withStatus(String status) {
            this.status = status;
            return this;
        }

        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder withConsumerCode(String consumerCode) {
            this.consumerCode = consumerCode;
            return this;
        }

        public Builder withMobileNumber(String mobileNumber) {
            this.mobileNumber = mobileNumber;
            return this;
        }

        public Builder withOwnername(String ownerName) {
            this.ownerName = ownerName;
            return this;
        }

        public Builder withAadharNumber(String aadharNumber) {
            this.aadharNumber = aadharNumber;
            return this;
        }

        public Builder withElapsedDays(Integer elapsedDays) {
            this.elapsedDays = elapsedDays;
            return this;
        }

        public Builder withClosed(ClosureStatus closed) {
            this.closed = closed;
            return this;
        }

        public Builder withApproved(ApprovalStatus approved) {
            this.approved = approved;
            return this;
        }

        public Builder withChannel(String channel) {
            this.channel = channel;
            return this;
        }

        public Builder withSla(Integer sla) {
            this.sla = sla;
            return this;
        }

        public ApplicationIndex build() {
            ApplicationIndex applicationIndex = new ApplicationIndex();
            applicationIndex.setModuleName(this.moduleName);
            applicationIndex.setApplicationNumber(this.applicationNumber);
            applicationIndex.setApplicationDate(this.applicationDate);
            applicationIndex.setApplicationType(this.applicationType);
            applicationIndex.setApplicantName(this.applicantName);
            applicationIndex.setApplicantAddress(this.applicantAddress);
            applicationIndex.setDisposalDate(this.disposalDate);
            applicationIndex.setStatus(this.status);
            applicationIndex.setUrl(this.url);
            applicationIndex.setConsumerCode(this.consumerCode);
            applicationIndex.setMobileNumber(this.mobileNumber);
            applicationIndex.setOwnerName(this.ownerName);
            applicationIndex.setAadharNumber(this.aadharNumber);
            applicationIndex.setElapsedDays(this.elapsedDays);
            applicationIndex.setClosed(this.closed);
            applicationIndex.setApproved(this.approved);
            applicationIndex.setChannel(this.channel);
            applicationIndex.setClosed(this.closed);
            applicationIndex.setSla(this.sla);
            applicationIndex.setSlaGap(this.elapsedDays - this.sla);
            return applicationIndex;
        }
    }
}

