/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.persistence.event.listener;

import java.io.Serializable;
import java.util.Date;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.entity.Auditable;
import org.egov.infstr.models.BaseModel;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PreUpdateEvent;
import org.hibernate.event.spi.PreUpdateEventListener;
import org.hibernate.event.spi.SaveOrUpdateEvent;
import org.hibernate.event.spi.SaveOrUpdateEventListener;

public class HibernateEventListener
implements SaveOrUpdateEventListener,
PreUpdateEventListener {
    private static final long serialVersionUID = 1L;

    public boolean onPreUpdate(PreUpdateEvent event) {
        Object entity = event.getEntity();
        if (entity instanceof BaseModel) {
            this.updateAuditableProperties(event);
        } else if (entity instanceof Auditable) {
            this.updateAuditable(event);
        }
        return false;
    }

    public void onSaveOrUpdate(SaveOrUpdateEvent event) {
        EventSource session = event.getSession();
        Object object = event.getObject();
        if (object instanceof BaseModel && !session.getPersistenceContext().reassociateIfUninitializedProxy(object)) {
            Date currentDate = new Date();
            User usr = (User)session.load(User.class, (Serializable)ApplicationThreadLocals.getUserId());
            BaseModel entity = (BaseModel)session.getPersistenceContext().unproxyAndReassociate(object);
            if (entity.getCreatedBy() == null) {
                entity.setCreatedDate(currentDate);
                entity.setCreatedBy(usr);
                entity.setModifiedBy(usr);
                entity.setModifiedDate(currentDate);
            }
        } else if (object instanceof Auditable && !session.getPersistenceContext().reassociateIfUninitializedProxy(object)) {
            User usr = (User)session.load(User.class, (Serializable)ApplicationThreadLocals.getUserId());
            AbstractAuditable entity = (AbstractAuditable)session.getPersistenceContext().unproxyAndReassociate(object);
            if (entity.getCreatedBy() == null) {
                Date currentDate = new Date();
                entity.setCreatedDate(currentDate);
                entity.setCreatedBy(usr);
                entity.setLastModifiedBy(usr);
                entity.setLastModifiedDate(currentDate);
            }
        }
    }

    private User getUserObjectFromWithinEventListener(EventSource session) {
        SessionFactoryImplementor factory = session.getFactory();
        Session session2 = factory.openSession();
        User usr = (User)session2.load(User.class, (Serializable)ApplicationThreadLocals.getUserId());
        session2.flush();
        session2.close();
        return usr;
    }

    private void updateAuditableProperties(PreUpdateEvent event) {
        int i = 0;
        for (String propName : event.getPersister().getPropertyNames()) {
            if ("modifiedDate".equals(propName)) {
                event.getState()[i] = new Date();
            }
            if ("modifiedBy".equals(propName)) {
                event.getState()[i] = this.getUserObjectFromWithinEventListener(event.getSession());
            }
            ++i;
        }
    }

    private void updateAuditable(PreUpdateEvent event) {
        int i = 0;
        for (String propName : event.getPersister().getPropertyNames()) {
            if ("lastModifiedDate".equals(propName)) {
                event.getState()[i] = new Date();
            }
            if ("lastModifiedBy".equals(propName)) {
                event.getState()[i] = this.getUserObjectFromWithinEventListener(event.getSession());
            }
            ++i;
        }
    }
}

