/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.service;

import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.repository.CityRepository;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.messaging.MessagingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CityService {
    private static final String CITY_PREFS_CK = "%s-cityPrefs";
    private final CityRepository cityRepository;
    @Autowired
    private MessagingService messagingService;
    @Resource(name="redisTemplate")
    private HashOperations<String, String, Object> cityPrefCache;
    @Autowired
    private RedisTemplate<Object, Object> redisTemplate;

    @Autowired
    public CityService(CityRepository cityRepository) {
        this.cityRepository = cityRepository;
    }

    @Transactional
    public City updateCity(City city) {
        this.redisTemplate.delete((Object)this.cityPrefCacheKey());
        return (City)this.cityRepository.save(city);
    }

    public City getCityByURL(String url) {
        return this.cityRepository.findByDomainURL(url);
    }

    public City getCityByName(String cityName) {
        return this.cityRepository.findByName(cityName);
    }

    public City getCityByCode(String code) {
        return this.cityRepository.findByCode(code);
    }

    public List<City> findAll() {
        return this.cityRepository.findAll();
    }

    public void sentFeedBackMail(String email, String subject, String message) {
        this.messagingService.sendEmail(email, subject, message);
    }

    public Map<String, Object> cityDataAsMap() {
        Map cityPrefs = this.cityPrefCache.entries((Object)this.cityPrefCacheKey());
        if (cityPrefs.isEmpty()) {
            this.cityPrefCache.putAll((Object)this.cityPrefCacheKey(), this.getCityByURL(ApplicationThreadLocals.getDomainName()).toMap());
            cityPrefs = this.cityPrefCache.entries((Object)this.cityPrefCacheKey());
        }
        return cityPrefs;
    }

    public String getCityCode() {
        return (String)this.cityDataForKey("cityCode");
    }

    public String getMunicipalityName() {
        return (String)this.cityDataForKey("citymunicipalityname");
    }

    public String getCityGrade() {
        return (String)this.cityDataForKey("cityGrade");
    }

    public String getDistrictName() {
        return (String)this.cityDataForKey("districtName");
    }

    public String getCityLogoPath() {
        return (String)this.cityDataForKey("citylogo");
    }

    public String cityPrefCacheKey() {
        return String.format(CITY_PREFS_CK, ApplicationThreadLocals.getDomainName());
    }

    public Object cityDataForKey(String key) {
        return this.cityPrefCache.entries((Object)this.cityPrefCacheKey()).get(key);
    }
}

