/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.gson.annotations.Expose;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.egov.infra.admin.master.entity.AppConfig;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="eg_appconfig_values")
@SequenceGenerator(name="SEQ_EG_APPCONFIG_VALUES", sequenceName="SEQ_EG_APPCONFIG_VALUES", allocationSize=1)
public class AppConfigValues
extends AbstractAuditable {
    public static final String SEQ_APPCONFIG_VALUE = "SEQ_EG_APPCONFIG_VALUES";
    private static final long serialVersionUID = 1L;
    @Expose
    @Id
    @GeneratedValue(generator="SEQ_EG_APPCONFIG_VALUES", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotBlank
    @SafeHtml
    @Length(max=4000)
    @Column(name="value")
    private String value;
    @NotNull
    @Temporal(value=TemporalType.DATE)
    @Column(name="effective_from", updatable=false)
    private Date effectiveFrom;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="key_id", nullable=false)
    @JsonIgnore
    private AppConfig config;
    @Transient
    private boolean markedForRemoval;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public Date getEffectiveFrom() {
        return this.effectiveFrom;
    }

    public void setEffectiveFrom(Date effectiveFrom) {
        this.effectiveFrom = effectiveFrom;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public AppConfig getConfig() {
        return this.config;
    }

    public void setConfig(AppConfig config) {
        this.config = config;
    }

    public boolean isMarkedForRemoval() {
        return this.markedForRemoval;
    }

    public void setMarkedForRemoval(boolean markedForRemoval) {
        this.markedForRemoval = markedForRemoval;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AppConfigValues)) {
            return false;
        }
        AppConfigValues that = (AppConfigValues)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.value);
    }
}

