/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.workflow.service;

import java.util.Date;
import java.util.List;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.repository.StateRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class StateService {
    private final StateRepository stateRepository;

    @Autowired
    public StateService(StateRepository stateRepository) {
        this.stateRepository = stateRepository;
    }

    public boolean isPositionUnderWorkflow(Long posId, Date givenDate) {
        return this.stateRepository.countByOwnerPosition_IdAndCreatedDateGreaterThanEqual(posId, givenDate) > 0L;
    }

    public List<String> getAssignedWorkflowTypeNames(List<Long> ownerIds) {
        return this.stateRepository.findAllTypeByOwnerAndStatus(ownerIds);
    }

    public State getStateById(Long id) {
        return (State)this.stateRepository.findOne(id);
    }
}

