/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.workflow.matrix.entity;

import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.egov.infra.persistence.entity.AbstractPersistable;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="EG_WF_MATRIX")
@SequenceGenerator(name="SEQ_EG_WF_MATRIX", sequenceName="SEQ_EG_WF_MATRIX", allocationSize=1)
public class WorkFlowMatrix
extends AbstractPersistable<Long>
implements Cloneable {
    public static final String SEQ_WF_MATRIX = "SEQ_EG_WF_MATRIX";
    private static final long serialVersionUID = 4954386159285858993L;
    @Id
    @GeneratedValue(generator="SEQ_EG_WF_MATRIX", strategy=GenerationType.SEQUENCE)
    private Long id;
    @SafeHtml
    private String department;
    @NotNull
    @SafeHtml
    private String objectType;
    @SafeHtml
    private String currentState;
    @SafeHtml
    private String currentStatus;
    @SafeHtml
    private String pendingActions;
    @SafeHtml
    private String currentDesignation;
    @SafeHtml
    private String additionalRule;
    @SafeHtml
    private String nextState;
    @SafeHtml
    private String nextAction;
    @SafeHtml
    private String nextDesignation;
    @SafeHtml
    private String nextStatus;
    @SafeHtml
    private String validActions;
    private BigDecimal fromQty;
    private BigDecimal toQty;
    @Temporal(value=TemporalType.DATE)
    private Date fromDate;
    @Temporal(value=TemporalType.DATE)
    private Date toDate;

    public WorkFlowMatrix() {
    }

    public WorkFlowMatrix(String department, String objectType, String currentState, String currentStatus, String pendingActions, String currentDesignation, String additionalRule, String nextState, String nextAction, String nextDesignation, String nextStatus, String validActions, BigDecimal fromQty, BigDecimal toQty, Date fromDate, Date toDate) {
        this.department = department;
        this.objectType = objectType;
        this.currentState = currentState;
        this.currentStatus = currentStatus;
        this.pendingActions = pendingActions;
        this.currentDesignation = currentDesignation;
        this.additionalRule = additionalRule;
        this.nextState = nextState;
        this.nextAction = nextAction;
        this.nextDesignation = nextDesignation;
        this.nextStatus = nextStatus;
        this.validActions = validActions;
        this.fromQty = fromQty;
        this.toQty = toQty;
        this.fromDate = fromDate;
        this.toDate = toDate;
    }

    public WorkFlowMatrix clone() {
        return new WorkFlowMatrix(this.department, this.objectType, this.currentState, this.currentStatus, this.pendingActions, this.currentDesignation, this.additionalRule, this.nextState, this.nextAction, this.nextDesignation, this.nextStatus, this.validActions, this.fromQty, this.toQty, this.fromDate, this.toDate);
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public String getCurrentState() {
        return this.currentState;
    }

    public void setCurrentState(String currentState) {
        this.currentState = currentState;
    }

    public String getCurrentStatus() {
        return this.currentStatus;
    }

    public void setCurrentStatus(String currentStatus) {
        this.currentStatus = currentStatus;
    }

    public String getPendingActions() {
        return this.pendingActions;
    }

    public void setPendingActions(String pendingActions) {
        this.pendingActions = pendingActions;
    }

    public String getCurrentDesignation() {
        return this.currentDesignation;
    }

    public void setCurrentDesignation(String currentDesignation) {
        this.currentDesignation = currentDesignation;
    }

    public String getAdditionalRule() {
        return this.additionalRule;
    }

    public void setAdditionalRule(String additionalRule) {
        this.additionalRule = additionalRule;
    }

    public String getNextState() {
        return this.nextState;
    }

    public void setNextState(String nextState) {
        this.nextState = nextState;
    }

    public String getNextAction() {
        return this.nextAction;
    }

    public void setNextAction(String nextAction) {
        this.nextAction = nextAction;
    }

    public String getNextDesignation() {
        return this.nextDesignation;
    }

    public void setNextDesignation(String nextDesignation) {
        this.nextDesignation = nextDesignation;
    }

    public String getNextStatus() {
        return this.nextStatus;
    }

    public void setNextStatus(String nextStatus) {
        this.nextStatus = nextStatus;
    }

    public String getValidActions() {
        return this.validActions;
    }

    public void setValidActions(String validActions) {
        this.validActions = validActions;
    }

    public BigDecimal getFromQty() {
        return this.fromQty;
    }

    public void setFromQty(BigDecimal fromQty) {
        this.fromQty = fromQty;
    }

    public BigDecimal getToQty() {
        return this.toQty;
    }

    public void setToQty(BigDecimal toQty) {
        this.toQty = toQty;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }
}

