/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.workflow.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infra.workflow.entity.contract.StateInfoBuilder;
import org.egov.pims.commons.Position;
import org.hibernate.envers.Audited;
import org.hibernate.envers.RelationTargetAuditMode;

@MappedSuperclass
public abstract class StateAware
extends AbstractAuditable {
    private static final long serialVersionUID = 5776408218810221246L;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="STATE_ID")
    private State state;
    @Transient
    @JsonIgnore
    private Transition transition;

    public static Comparator<StateAware> byCreatedDate() {
        return (stateAware1, stateAware2) -> {
            int returnVal = 1;
            if (stateAware1 == null) {
                returnVal = stateAware2 == null ? 0 : -1;
            } else if (stateAware2 == null) {
                returnVal = 1;
            } else {
                Date createdDate2;
                Date createdDate1 = stateAware1.getState().getCreatedDate();
                if (createdDate1.after(createdDate2 = stateAware2.getState().getCreatedDate())) {
                    returnVal = -1;
                } else if (createdDate1.equals(createdDate2)) {
                    returnVal = 0;
                }
            }
            return returnVal;
        };
    }

    public abstract String getStateDetails();

    public String myLinkId() {
        return ((Long)this.getId()).toString();
    }

    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    public State getState() {
        return this.state;
    }

    private void setState(State state) {
        this.state = state;
    }

    public final State getCurrentState() {
        return this.state;
    }

    public final List<StateHistory> getStateHistory() {
        return this.state == null ? Collections.emptyList() : new LinkedList<StateHistory>(this.state.getHistory());
    }

    public final String getStateType() {
        return this.getClass().getSimpleName();
    }

    public final boolean transitionInitialized() {
        return this.hasState() && this.getCurrentState().isNew();
    }

    public final boolean transitionCompleted() {
        return this.hasState() && this.getCurrentState().isEnded();
    }

    public final boolean transitionInprogress() {
        return this.hasState() && this.getCurrentState().isInprogress();
    }

    public final boolean hasState() {
        return this.getCurrentState() != null;
    }

    public final Transition transition() {
        if (this.transition == null) {
            this.transition = new Transition();
        }
        return this.transition;
    }

    protected StateInfoBuilder buildStateInfo() {
        return new StateInfoBuilder().task(this.getState().getNatureOfTask()).itemDetails(this.getStateDetails()).status(this.getCurrentState().getStatus().name()).refDate(this.getCreatedDate()).sender(this.getState().getSenderName()).senderPhoneno(this.getState().getExtraInfo());
    }

    public String getStateInfoJson() {
        return this.buildStateInfo().toJson();
    }

    public final class Transition
    implements Serializable {
        private static final long serialVersionUID = -6035435855091367838L;
        private boolean transitionInitiated;

        private void checkinTransition() {
            if (this.transitionInitiated) {
                throw new ApplicationRuntimeException("Calling multiple transitions not supported");
            }
            this.transitionInitiated = true;
        }

        private void checkTransitionStatus() {
            if (!this.transitionInitiated) {
                throw new ApplicationRuntimeException("Use start|progress|end API before setting values");
            }
        }

        public final Transition start() {
            this.checkinTransition();
            if (StateAware.this.hasState()) {
                throw new ApplicationRuntimeException("Transition already started.");
            }
            StateAware.this.state = new State();
            StateAware.this.state.setType(StateAware.this.getStateType());
            StateAware.this.state.setStatus(State.StateStatus.STARTED);
            StateAware.this.state.setValue("Created");
            StateAware.this.state.setComments("Created");
            return this;
        }

        public final Transition startNext() {
            if (StateAware.this.state == null) {
                throw new ApplicationRuntimeException("Transition never started, use start() instead");
            }
            if (!StateAware.this.transitionCompleted()) {
                throw new ApplicationRuntimeException("Transition can not be started, end the current transition first");
            }
            State previousState = StateAware.this.state;
            StateAware.this.state = null;
            this.start();
            StateAware.this.state.setPreviousStateRef(previousState);
            return this;
        }

        public final Transition progress() {
            this.progressWithStateCopy();
            this.resetState();
            return this;
        }

        public final Transition progressWithStateCopy() {
            this.checkinTransition();
            if (StateAware.this.hasState()) {
                StateAware.this.state.addStateHistory(new StateHistory(StateAware.this.state));
                StateAware.this.state.setStatus(State.StateStatus.INPROGRESS);
            }
            return this;
        }

        public final Transition end() {
            this.checkinTransition();
            if (StateAware.this.transitionCompleted()) {
                throw new ApplicationRuntimeException("Transition already ended");
            }
            StateAware.this.state.addStateHistory(new StateHistory(StateAware.this.state));
            StateAware.this.state.setValue("Closed");
            StateAware.this.state.setStatus(State.StateStatus.ENDED);
            StateAware.this.state.setComments("Closed");
            return this;
        }

        public final Transition reopen() {
            this.checkinTransition();
            if (!StateAware.this.transitionCompleted()) {
                throw new ApplicationRuntimeException("Transition can not be reopened, end the current transition first");
            }
            StateHistory stateHistory = new StateHistory(StateAware.this.state);
            stateHistory.setValue("Reopened");
            StateAware.this.state.setStatus(State.StateStatus.INPROGRESS);
            StateAware.this.state.addStateHistory(stateHistory);
            return this;
        }

        public final Transition withOwner(User owner) {
            this.checkTransitionStatus();
            StateAware.this.state.setOwnerUser(owner);
            return this;
        }

        public final Transition withOwner(Position owner) {
            this.checkTransitionStatus();
            StateAware.this.state.setOwnerPosition(owner);
            return this;
        }

        public final Transition withInitiator(Position owner) {
            this.checkTransitionStatus();
            StateAware.this.state.setInitiatorPosition(owner);
            return this;
        }

        public final Transition withStateValue(String currentStateValue) {
            this.checkTransitionStatus();
            StateAware.this.state.setValue(currentStateValue);
            return this;
        }

        public final Transition withNextAction(String nextAction) {
            this.checkTransitionStatus();
            StateAware.this.state.setNextAction(nextAction);
            return this;
        }

        public final Transition withComments(String comments) {
            this.checkTransitionStatus();
            StateAware.this.state.setComments(comments);
            return this;
        }

        public final Transition withNatureOfTask(String natureOfTask) {
            this.checkTransitionStatus();
            StateAware.this.state.setNatureOfTask(natureOfTask);
            return this;
        }

        public final Transition withExtraInfo(String extraInfo) {
            this.checkTransitionStatus();
            StateAware.this.state.setExtraInfo(extraInfo);
            return this;
        }

        public final Transition withDateInfo(Date dateInfo) {
            this.checkTransitionStatus();
            StateAware.this.state.setDateInfo(dateInfo);
            return this;
        }

        public final Transition withExtraDateInfo(Date extraDateInfo) {
            this.checkTransitionStatus();
            StateAware.this.state.setExtraDateInfo(extraDateInfo);
            return this;
        }

        public final Transition withSenderName(String senderName) {
            this.checkTransitionStatus();
            StateAware.this.state.setSenderName(senderName);
            return this;
        }

        private void resetState() {
            StateAware.this.state.setComments("");
            StateAware.this.state.setDateInfo(null);
            StateAware.this.state.setExtraDateInfo(null);
            StateAware.this.state.setExtraInfo("");
            StateAware.this.state.setNextAction("");
            StateAware.this.state.setValue("");
            StateAware.this.state.setSenderName("");
            StateAware.this.state.setNatureOfTask("");
            StateAware.this.state.setOwnerUser(null);
            StateAware.this.state.setOwnerPosition(null);
            StateAware.this.state.setInitiatorPosition(null);
        }
    }
}

