/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.utils;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.egov.infra.exception.ApplicationRuntimeException;

public final class PdfUtils {
    private PdfUtils() {
    }

    public static byte[] appendFiles(List<InputStream> inputPdfList, OutputStream outputStream) {
        try {
            Document document = new Document();
            ArrayList<PdfReader> readers = new ArrayList<PdfReader>();
            int totalPages = 0;
            for (InputStream pdf : inputPdfList) {
                if (pdf == null) break;
                PdfReader pdfReader = new PdfReader(pdf);
                readers.add(pdfReader);
                totalPages += pdfReader.getNumberOfPages();
            }
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
            document.open();
            PdfContentByte pageContentByte = writer.getDirectContent();
            int currentPdfReaderPage = 1;
            for (PdfReader pdfReader : readers) {
                while (currentPdfReaderPage <= pdfReader.getNumberOfPages()) {
                    document.newPage();
                    PdfImportedPage pdfImportedPage = writer.getImportedPage(pdfReader, currentPdfReaderPage);
                    pageContentByte.addTemplate((PdfTemplate)pdfImportedPage, 0.0f, 0.0f);
                    ++currentPdfReaderPage;
                }
                currentPdfReaderPage = 1;
            }
            outputStream.flush();
            document.close();
            outputStream.close();
            return ((ByteArrayOutputStream)outputStream).toByteArray();
        }
        catch (DocumentException | IOException e) {
            throw new ApplicationRuntimeException("Error occurred while appending pdfs", e);
        }
    }
}

