/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.utils;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import org.apache.commons.lang.StringUtils;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberToWord {
    private static final Logger LOGGER = LoggerFactory.getLogger(NumberToWord.class);
    private static final long ZEROS = 0L;
    private static final long UNITS = 1L;
    private static final long TENS = 10L;
    private static final long HUNDREDS = 100L;
    private static final long THOUSANDS = 1000L;
    private static final long TENTHOUSANDS = 10000L;
    private static final long LAKHS = 100000L;
    private static final long TENLAKHS = 1000000L;
    private static final long CRORES = 10000000L;
    private static final long TENCRORES = 100000000L;
    private static final long HUNDREDCRORES = 1000000000L;
    private static final long THOUSANDCRORES = 10000000000L;
    private static final long TENTHOUSANDCRORES = 100000000000L;
    private static final String[] CARDINAL = new String[]{"Zero", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine", "Ten", "Eleven", "Twelve", "Thirteen", "Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eighteen", "Nineteen", "Twenty", "Thirty", "Forty", "Fifty", "Sixty", "Seventy", "Eighty", "Ninety", "Hundred"};

    public static String formatDecimal(Double value) {
        DecimalFormat formater = new DecimalFormat("###0.00");
        FieldPosition _fldPos = new FieldPosition(0);
        StringBuffer _adaptor = new StringBuffer();
        formater.format(value, _adaptor, _fldPos);
        return _adaptor.toString();
    }

    public static String amountInWords(Double number) {
        return NumberToWord.convertToWord(NumberToWord.formatDecimal((double)number));
    }

    public static String numberToString(String strNumberToConvert) {
        if (StringUtils.contains((String)strNumberToConvert, (String)".")) {
            throw new ApplicationRuntimeException("Can not pass decimal values");
        }
        return NumberToWord.convertToWord(strNumberToConvert).replace("Rupees", "").replace("Only", "");
    }

    public static String convertToWord(String number) {
        String paise = "";
        if (number.contains(".")) {
            String[] splitPaise = number.split("[.]");
            if (splitPaise.length == 2 && !splitPaise[1].equals("00")) {
                paise = "and " + NumberToWord.paiseInWords(splitPaise[1]) + " " + "Paise Only";
            }
            number = splitPaise[0];
        }
        String returnValue = NumberToWord.translateToWord(number);
        return paise.isEmpty() ? "Rupees " + returnValue + " Only " : "Rupees " + returnValue + " " + paise;
    }

    public static String translateToWord(String number) {
        long num = 0L;
        try {
            num = Long.parseLong(number);
        }
        catch (NumberFormatException e) {
            LOGGER.error("Invalid Number, Please enter a valid Number.");
            throw new ApplicationRuntimeException("Exception occurred in convertToWord", e);
        }
        Long subNum = 0L;
        String returnValue = "";
        if (Long.parseLong(number) == 0L || number.length() > 12) {
            returnValue = returnValue + NumberToWord.getWord(Long.parseLong(number));
        }
        while (num > 0L && number.length() <= 12) {
            number = "" + num;
            long place = NumberToWord.getPlace(number);
            if (place == 1000000000L || place == 10000000000L || place == 100000000000L) {
                subNum = Long.parseLong("" + number.charAt(0));
                returnValue = returnValue + NumberToWord.getWord(subNum);
                if (place == 1000000000L) {
                    if ((num -= subNum * 1000000000L) == 0L) {
                        returnValue = returnValue + " Hundred Crores ";
                        continue;
                    }
                    returnValue = returnValue + " Hundred ";
                    continue;
                }
                if (place == 10000000000L) {
                    if ((num -= subNum * 10000000000L) == 0L) {
                        returnValue = returnValue + " Thousand Crores ";
                        continue;
                    }
                    returnValue = returnValue + " Thousand  ";
                    continue;
                }
                returnValue = "";
                subNum = Long.parseLong(number.charAt(0) + "" + number.charAt(1));
                if (subNum >= 21L && subNum % 10L != 0L && (num -= subNum * 10000000000L) == 0L) {
                    returnValue = returnValue + NumberToWord.getWord(Long.parseLong(String.valueOf(number.charAt(0))) * 10L) + " " + NumberToWord.getWord(subNum % 10L) + " Thousand Crores ";
                    continue;
                }
                if (num == 0L) {
                    returnValue = returnValue + NumberToWord.getWord(Long.parseLong(String.valueOf(number.charAt(0))) * 10L) + " " + " Thousand Crores ";
                    continue;
                }
                returnValue = returnValue + NumberToWord.getWord(Long.parseLong(String.valueOf(number.charAt(0))) * 10L) + " " + NumberToWord.getWord(subNum % 10L) + " Thousand  ";
                continue;
            }
            if (place == 10L || place == 10000L || place == 1000000L || place == 100000000L) {
                subNum = Long.parseLong(String.valueOf(number.charAt(0)) + String.valueOf(number.charAt(1)));
                returnValue = subNum >= 21L && subNum % 10L != 0L ? returnValue + NumberToWord.getWord(Long.parseLong(String.valueOf(number.charAt(0))) * 10L) + " " + NumberToWord.getWord(subNum % 10L) : returnValue + NumberToWord.getWord(subNum);
                if (place == 10L) {
                    num = 0L;
                    continue;
                }
                if (place == 10000L) {
                    num -= subNum * 1000L;
                    returnValue = returnValue + " Thousands ";
                    continue;
                }
                if (place == 1000000L) {
                    num -= subNum * 100000L;
                    returnValue = returnValue + " Lakhs ";
                    continue;
                }
                if (place != 100000000L) continue;
                num -= subNum * 10000000L;
                returnValue = returnValue + " Crores ";
                continue;
            }
            subNum = Long.parseLong(String.valueOf(number.charAt(0)));
            returnValue = returnValue + NumberToWord.getWord(subNum);
            if (place == 1L) {
                num = 0L;
                continue;
            }
            if (place == 100L) {
                num -= subNum * 100L;
                returnValue = returnValue + " Hundred ";
                continue;
            }
            if (place == 1000L) {
                num -= subNum * 1000L;
                returnValue = returnValue + " Thousand ";
                continue;
            }
            if (place == 100000L) {
                num -= subNum * 100000L;
                returnValue = returnValue + " Lakh ";
                continue;
            }
            if (place != 10000000L) continue;
            num -= subNum * 10000000L;
            returnValue = returnValue + " Crore ";
        }
        return returnValue;
    }

    private static String normalize(String number) {
        String cleanedNumber = number.replace(',', ' ').replaceAll(" ", "");
        if (number.length() > 1 && cleanedNumber.startsWith("0")) {
            return cleanedNumber.replaceFirst("0", "");
        }
        return cleanedNumber;
    }

    private static long getPlace(String number) {
        switch (number.length()) {
            case 1: {
                return 1L;
            }
            case 2: {
                return 10L;
            }
            case 3: {
                return 100L;
            }
            case 4: {
                return 1000L;
            }
            case 5: {
                return 10000L;
            }
            case 6: {
                return 100000L;
            }
            case 7: {
                return 1000000L;
            }
            case 8: {
                return 10000000L;
            }
            case 9: {
                return 100000000L;
            }
            case 10: {
                return 1000000000L;
            }
            case 11: {
                return 10000000000L;
            }
            case 12: {
                return 100000000000L;
            }
        }
        return 0L;
    }

    public static String getWord(Long number) {
        int value = number.intValue();
        switch (value) {
            case 30: {
                return CARDINAL[21];
            }
            case 40: {
                return CARDINAL[22];
            }
            case 50: {
                return CARDINAL[23];
            }
            case 60: {
                return CARDINAL[24];
            }
            case 70: {
                return CARDINAL[25];
            }
            case 80: {
                return CARDINAL[26];
            }
            case 90: {
                return CARDINAL[27];
            }
            case 100: {
                return CARDINAL[28];
            }
        }
        if (value < 21) {
            return CARDINAL[value];
        }
        return "";
    }

    private static String paiseInWords(String paise) {
        Long subNum = 0L;
        String returnValue = "";
        subNum = paise.length() >= 2 ? Long.valueOf(Long.parseLong(paise.charAt(0) + "" + paise.charAt(1))) : Long.valueOf(Long.parseLong(paise.charAt(0) + ""));
        returnValue = subNum >= 21L && subNum % 10L != 0L ? returnValue + NumberToWord.getWord(Long.parseLong("" + paise.charAt(0)) * 10L) + " " + NumberToWord.getWord(subNum % 10L) : returnValue + NumberToWord.getWord(subNum);
        return returnValue;
    }
}

