/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class ImageUtils {
    public static final String JPG_EXTN = ".jpg";

    private ImageUtils() {
    }

    public static File compressImage(MultipartFile imageFile) throws IOException {
        return ImageUtils.compressImage(imageFile.getInputStream(), imageFile.getOriginalFilename(), true);
    }

    public static File compressImage(InputStream imageStream, String imageFileName, boolean closeStream) throws IOException {
        File compressedImage = Paths.get(imageFileName, new String[0]).toFile();
        try (ImageOutputStream imageOutput = ImageIO.createImageOutputStream(compressedImage);){
            ImageWriter writer = ImageIO.getImageWritersByFormatName(StringUtils.defaultString((String)FilenameUtils.getExtension((String)imageFileName), (String)"jpeg")).next();
            writer.setOutput(imageOutput);
            ImageWriteParam writeParam = writer.getDefaultWriteParam();
            if (writeParam.canWriteCompressed()) {
                writeParam.setCompressionMode(2);
                writeParam.setCompressionType(writeParam.getCompressionTypes()[0]);
                writeParam.setCompressionQuality(0.05f);
            }
            writer.write(null, new IIOImage(ImageIO.read(imageStream), null, null), writeParam);
            writer.dispose();
            if (closeStream) {
                imageStream.close();
            }
        }
        return compressedImage;
    }
}

