/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.reporting.viewer;

import java.util.EnumMap;
import java.util.UUID;
import org.egov.infra.cache.impl.ApplicationCacheManager;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.reporting.engine.ReportOutput;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportViewerUtil {
    private static final EnumMap<ReportConstants.FileFormat, String> contentTypes = ReportViewerUtil.getContentTypes();
    @Autowired
    private ApplicationCacheManager applicationCacheManager;

    private static EnumMap<ReportConstants.FileFormat, String> getContentTypes() {
        EnumMap<ReportConstants.FileFormat, String> contentTypes = new EnumMap<ReportConstants.FileFormat, String>(ReportConstants.FileFormat.class);
        contentTypes.put(ReportConstants.FileFormat.PDF, "application/pdf");
        contentTypes.put(ReportConstants.FileFormat.XLS, "application/vnd.ms-excel");
        contentTypes.put(ReportConstants.FileFormat.RTF, "application/rtf");
        contentTypes.put(ReportConstants.FileFormat.HTM, "text/html");
        contentTypes.put(ReportConstants.FileFormat.TXT, "text/plain");
        contentTypes.put(ReportConstants.FileFormat.CSV, "text/plain");
        return contentTypes;
    }

    public static String getContentType(ReportConstants.FileFormat fileFormat) {
        return contentTypes.get((Object)fileFormat);
    }

    public static String getContentDisposition(ReportConstants.FileFormat fileFormat) {
        return "inline; filename=report." + fileFormat.toString();
    }

    public String addReportToTempCache(ReportOutput reportOutput) {
        String reportId = UUID.randomUUID().toString();
        this.applicationCacheManager.put(reportId, reportOutput);
        return reportId;
    }

    public ReportOutput getReportOutputFormCache(String reportOutputCacheKey) {
        return this.applicationCacheManager.get(reportOutputCacheKey, ReportOutput.class);
    }

    public void removeReportOutputFromCache(String reportOutputCacheKey) {
        this.applicationCacheManager.remove(reportOutputCacheKey);
    }
}

