/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.reporting.engine.jasper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.JRBeanArrayDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.export.HtmlExporter;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRTextExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.export.Exporter;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.SimpleCsvExporterConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleHtmlExporterConfiguration;
import net.sf.jasperreports.export.SimpleHtmlExporterOutput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimplePdfExporterConfiguration;
import net.sf.jasperreports.export.SimpleRtfExporterConfiguration;
import net.sf.jasperreports.export.SimpleTextExporterConfiguration;
import net.sf.jasperreports.export.SimpleXlsExporterConfiguration;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.reporting.engine.AbstractReportService;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JasperReportService
extends AbstractReportService<JasperReport> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JasperReportService.class);
    private static final String TEMPLATE_EXTENSION = ".jasper";
    private static final String JASPER_PROPERTIES_FILE = "config/jasperreports.properties";
    private static final String EXCEPTION_IN_REPORT_CREATION = "Error occurred while generating report.";
    private static final String PRINT_PDF_JAVASCRIPT = "this.print()";
    @PersistenceContext
    private EntityManager entityManager;

    public JasperReportService(int templateCacheMinSize, int templateCacheMaxSize) {
        super(templateCacheMinSize, templateCacheMaxSize);
        System.setProperty("net.sf.jasperreports.properties", JASPER_PROPERTIES_FILE);
    }

    @Override
    protected String getTemplateExtension() {
        return TEMPLATE_EXTENSION;
    }

    @Override
    protected ReportOutput createReportFromSql(ReportRequest reportInput, Connection connection) {
        try {
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)((JasperReport)this.getTemplate(reportInput.getReportTemplate())), reportInput.getReportParams(), (Connection)connection);
            return new ReportOutput(this.exportReport(reportInput, jasperPrint), reportInput);
        }
        catch (IOException | JRException e) {
            LOGGER.error(EXCEPTION_IN_REPORT_CREATION, e);
            throw new ApplicationRuntimeException(EXCEPTION_IN_REPORT_CREATION, e);
        }
    }

    @Override
    protected ReportOutput createReportFromJavaBean(ReportRequest reportInput) {
        try {
            Object reportData = reportInput.getReportInputData();
            Object dataSource = reportData == null ? new JREmptyDataSource() : (reportData.getClass().isArray() ? new JRBeanArrayDataSource((Object[])reportData, false) : (reportData instanceof Collection ? new JRBeanCollectionDataSource((Collection)reportData, false) : new JRBeanArrayDataSource(new Object[]{reportData}, false)));
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)((JasperReport)this.getTemplate(reportInput.getReportTemplate())), reportInput.getReportParams(), (JRDataSource)dataSource);
            return new ReportOutput(this.exportReport(reportInput, jasperPrint), reportInput);
        }
        catch (IOException | JRException e) {
            LOGGER.error(EXCEPTION_IN_REPORT_CREATION, e);
            throw new ApplicationRuntimeException(EXCEPTION_IN_REPORT_CREATION, e);
        }
    }

    @Override
    protected ReportOutput createReportFromHql(ReportRequest reportInput) {
        try {
            Map<String, Object> reportParams = reportInput.getReportParams();
            if (reportParams == null) {
                reportParams = new HashMap<String, Object>();
            }
            reportParams.put("HIBERNATE_SESSION", this.entityManager.unwrap(Session.class));
            DefaultJasperReportsContext jrc = DefaultJasperReportsContext.getInstance();
            jrc.setValue("net.sf.jasperreports.hql.field.mapping.descriptions", (Object)false);
            JasperPrint jasperPrint = JasperFillManager.getInstance((JasperReportsContext)jrc).fill((JasperReport)this.getTemplate(reportInput.getReportTemplate()), reportParams);
            return new ReportOutput(this.exportReport(reportInput, jasperPrint), reportInput);
        }
        catch (IOException | JRException e) {
            LOGGER.error(EXCEPTION_IN_REPORT_CREATION, e);
            throw new ApplicationRuntimeException(EXCEPTION_IN_REPORT_CREATION, e);
        }
    }

    @Override
    protected JasperReport loadTemplate(InputStream templateInputStream) {
        try {
            return (JasperReport)JRLoader.loadObject((InputStream)templateInputStream);
        }
        catch (JRException e) {
            LOGGER.error(EXCEPTION_IN_REPORT_CREATION, (Throwable)e);
            throw new ApplicationRuntimeException(EXCEPTION_IN_REPORT_CREATION, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] exportReport(ReportRequest reportInput, JasperPrint jasperPrint) throws JRException, IOException {
        try (ByteArrayOutputStream reportOutputStream = new ByteArrayOutputStream();){
            Exporter exporter = this.getExporter(reportInput, jasperPrint, reportOutputStream);
            exporter.exportReport();
            byte[] byArray = reportOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            LOGGER.error(EXCEPTION_IN_REPORT_CREATION, (Throwable)e);
            throw new ApplicationRuntimeException(EXCEPTION_IN_REPORT_CREATION, e);
        }
    }

    private Exporter getExporter(ReportRequest reportInput, JasperPrint jasperPrint, OutputStream outputStream) {
        SimplePdfExporterConfiguration exporterConfiguration;
        JRXlsExporter exporter;
        SimpleOutputStreamExporterOutput exporterOutput = null;
        if (ReportConstants.FileFormat.PDF.equals((Object)reportInput.getReportFormat())) {
            SimplePdfExporterConfiguration pdfExporterConfiguration = new SimplePdfExporterConfiguration();
            if (reportInput.isPrintDialogOnOpenReport()) {
                pdfExporterConfiguration.setPdfJavaScript(PRINT_PDF_JAVASCRIPT);
            }
            exporter = new JRPdfExporter();
            exporterConfiguration = pdfExporterConfiguration;
        } else if (ReportConstants.FileFormat.XLS.equals((Object)reportInput.getReportFormat())) {
            exporter = new JRXlsExporter();
            exporterConfiguration = new SimpleXlsExporterConfiguration();
        } else if (ReportConstants.FileFormat.RTF.equals((Object)reportInput.getReportFormat())) {
            exporter = new JRRtfExporter();
            exporterConfiguration = new SimpleRtfExporterConfiguration();
        } else if (ReportConstants.FileFormat.HTM.equals((Object)reportInput.getReportFormat())) {
            exporter = new HtmlExporter();
            exporterConfiguration = new SimpleHtmlExporterConfiguration();
            exporterOutput = new SimpleHtmlExporterOutput(outputStream);
        } else if (ReportConstants.FileFormat.TXT.equals((Object)reportInput.getReportFormat())) {
            exporter = new JRTextExporter();
            exporterConfiguration = new SimpleTextExporterConfiguration();
        } else if (ReportConstants.FileFormat.CSV.equals((Object)reportInput.getReportFormat())) {
            exporter = new JRCsvExporter();
            exporterConfiguration = new SimpleCsvExporterConfiguration();
        } else {
            throw new ApplicationRuntimeException("Invalid report format [" + (Object)((Object)reportInput.getReportFormat()) + "]");
        }
        exporter.setConfiguration((ExporterConfiguration)exporterConfiguration);
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
        exporter.setExporterOutput((ExporterOutput)(exporterOutput == null ? new SimpleOutputStreamExporterOutput(outputStream) : exporterOutput));
        return exporter;
    }
}

