/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.persistence.utils;

import javax.persistence.EntityManager;
import org.hibernate.Session;
import org.hibernate.proxy.HibernateProxy;

public final class PersistenceUtils {
    private PersistenceUtils() {
    }

    public static <T> T unproxy(T object) {
        if (object instanceof HibernateProxy) {
            return (T)((HibernateProxy)object).getHibernateLazyInitializer().getImplementation();
        }
        return object;
    }

    public static void flushBatchUpdate(EntityManager entityManager, int batchUpdateCount, int batchSize) {
        if (batchUpdateCount % batchSize == 0) {
            ((Session)entityManager.unwrap(Session.class)).flush();
            ((Session)entityManager.unwrap(Session.class)).clear();
        }
    }
}

