/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.persistence.datasource;

import javax.sql.DataSource;
import org.egov.infra.config.persistence.datasource.DatasourceConfigCondition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;
import org.springframework.jndi.JndiObjectFactoryBean;

@Configuration
@Profile(value={"production"})
@Conditional(value={DatasourceConfigCondition.class})
public class DatasourceConfiguration {
    @Autowired
    private Environment env;

    @Bean
    public JndiObjectFactoryBean dataSource() {
        JndiObjectFactoryBean dataSource = new JndiObjectFactoryBean();
        dataSource.setExpectedType(DataSource.class);
        dataSource.setJndiName(this.env.getProperty("default.jdbc.jndi.datasource"));
        return dataSource;
    }
}

