/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.persistence;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.sql.DataSource;
import org.egov.infra.config.properties.ApplicationProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Profile;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.data.jpa.support.ClasspathScanningPersistenceUnitPostProcessor;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitPostProcessor;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.jta.JtaTransactionManager;

@Configuration
@EnableTransactionManagement(proxyTargetClass=true)
@PropertySource(value={"classpath:config/persistence-config.properties"})
@Profile(value={"production"})
public class JpaConfiguration {
    @Autowired
    private Environment env;
    @Autowired
    private DataSource dataSource;
    @Autowired
    private ApplicationProperties applicationProperties;

    @Bean
    public PlatformTransactionManager transactionManager() {
        return new JtaTransactionManager();
    }

    @Bean
    @DependsOn(value={"flyway"})
    public EntityManagerFactory entityManagerFactory() {
        LocalContainerEntityManagerFactoryBean entityManagerFactory = new LocalContainerEntityManagerFactoryBean();
        entityManagerFactory.setJtaDataSource(this.dataSource);
        entityManagerFactory.setPersistenceUnitName("EgovPersistenceUnit");
        entityManagerFactory.setPackagesToScan(new String[]{"org.egov.**.entity"});
        entityManagerFactory.setJpaVendorAdapter(this.jpaVendorAdapter());
        entityManagerFactory.setJpaPropertyMap(this.additionalProperties());
        entityManagerFactory.setValidationMode(ValidationMode.NONE);
        entityManagerFactory.setSharedCacheMode(SharedCacheMode.DISABLE_SELECTIVE);
        ClasspathScanningPersistenceUnitPostProcessor hbmScanner = new ClasspathScanningPersistenceUnitPostProcessor("org.egov");
        hbmScanner.setMappingFileNamePattern("**/*hbm.xml");
        entityManagerFactory.setPersistenceUnitPostProcessors(new PersistenceUnitPostProcessor[]{hbmScanner});
        entityManagerFactory.afterPropertiesSet();
        return entityManagerFactory.getObject();
    }

    @Bean
    public JpaVendorAdapter jpaVendorAdapter() {
        HibernateJpaVendorAdapter vendorAdapter = new HibernateJpaVendorAdapter();
        vendorAdapter.setDatabase((Database)this.env.getProperty("jpa.database", Database.class));
        vendorAdapter.setShowSql(this.applicationProperties.getProperty("jpa.showSql", Boolean.class).booleanValue());
        vendorAdapter.setGenerateDdl(((Boolean)this.env.getProperty("jpa.generateDdl", Boolean.class)).booleanValue());
        return vendorAdapter;
    }

    private Map<String, Object> additionalProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("hibernate.validator.apply_to_ddl", false);
        properties.put("hibernate.validator.autoregister_listeners", false);
        properties.put("hibernate.temp.use_jdbc_metadata_defaults", false);
        properties.put("hibernate.dialect", this.env.getProperty("hibernate.dialect"));
        properties.put("hibernate.generate_statistics", this.applicationProperties.getProperty("hibernate.generate_statistics"));
        properties.put("hibernate.cache.region.factory_class", this.env.getProperty("hibernate.cache.region.factory_class"));
        properties.put("hibernate.cache.use_second_level_cache", this.applicationProperties.getProperty("hibernate.cache.use_second_level_cache"));
        properties.put("hibernate.cache.use_query_cache", this.applicationProperties.getProperty("hibernate.cache.use_query_cache"));
        properties.put("hibernate.cache.use_minimal_puts", this.env.getProperty("hibernate.cache.use_minimal_puts"));
        properties.put("hibernate.cache.infinispan.cachemanager", this.env.getProperty("hibernate.cache.infinispan.cachemanager"));
        properties.put("hibernate.transaction.jta.platform", this.env.getProperty("hibernate.transaction.jta.platform"));
        properties.put("hibernate.transaction.auto_close_session", this.env.getProperty("hibernate.transaction.auto_close_session"));
        properties.put("hibernate.jdbc.use_streams_for_binary", this.env.getProperty("hibernate.jdbc.use_streams_for_binary"));
        properties.put("hibernate.default_batch_fetch_size", this.applicationProperties.getBatchUpdateSize());
        properties.put("hibernate.jdbc.batch_versioned_data", true);
        properties.put("hibernate.order_inserts", true);
        properties.put("hibernate.order_updates", true);
        properties.put("hibernate.connection.autocommit", false);
        properties.put("jadira.usertype.autoRegisterUserTypes", true);
        properties.put("jadira.usertype.databaseZone", "jvm");
        if (this.applicationProperties.multiTenancyEnabled()) {
            properties.put("hibernate.multiTenancy", this.env.getProperty("hibernate.multiTenancy"));
            properties.put("hibernate.database.type", this.env.getProperty("jpa.database"));
            if ("SCHEMA".equals(this.env.getProperty("hibernate.multiTenancy"))) {
                properties.put("hibernate.multi_tenant_connection_provider", "org.egov.infra.config.persistence.multitenancy.MultiTenantSchemaConnectionProvider");
                properties.put("hibernate.tenant_identifier_resolver", "org.egov.infra.config.persistence.multitenancy.DomainBasedSchemaTenantIdentifierResolver");
            } else if ("DATABASE".equals(this.env.getProperty("hibernate.multiTenancy"))) {
                properties.put("hibernate.multi_tenant_connection_provider", "org.egov.infra.config.persistence.multitenancy.MultiTenantDatabaseConnectionProvider");
                properties.put("hibernate.tenant_identifier_resolver", "org.egov.infra.config.persistence.multitenancy.DomainBasedDatabaseTenantIdentifierResolver");
            }
        }
        return properties;
    }
}

