/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.annotation.Resource;
import org.egov.infra.config.properties.ApplicationProperties;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.reporting.engine.jasper.JasperReportService;
import org.springframework.beans.factory.annotation.Autowire;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;

@Configuration
@EnableAspectJAutoProxy(proxyTargetClass=true)
public class ApplicationConfiguration {
    @Resource(name="tenants")
    private List<String> tenants;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private ApplicationProperties applicationProperties;

    @Bean
    public FileStoreService fileStoreService() {
        return (FileStoreService)this.context.getBean(this.applicationProperties.filestoreServiceBeanName());
    }

    @Bean
    public LocaleResolver localeResolver() {
        return new SessionLocaleResolver();
    }

    @Bean
    public JavaMailSenderImpl mailSender() {
        JavaMailSenderImpl mailSender = new JavaMailSenderImpl();
        mailSender.setPort(this.applicationProperties.mailPort().intValue());
        mailSender.setHost(this.applicationProperties.mailHost());
        mailSender.setProtocol(this.applicationProperties.mailProtocol());
        mailSender.setUsername(this.applicationProperties.mailSenderUsername());
        mailSender.setPassword(this.applicationProperties.mailSenderPassword());
        Properties mailProperties = new Properties();
        mailProperties.setProperty("mail.smtps.auth", this.applicationProperties.mailSMTPSAuth());
        mailProperties.setProperty("mail.smtps.starttls.enable", this.applicationProperties.mailStartTLSEnabled());
        mailProperties.setProperty("mail.smtps.debug", this.applicationProperties.mailSMTPSDebug());
        mailSender.setJavaMailProperties(mailProperties);
        return mailSender;
    }

    @Bean(name={"cities"}, autowire=Autowire.BY_NAME)
    @DependsOn(value={"tenants"})
    public List<String> cities() {
        ArrayList<String> cities = new ArrayList<String>(this.tenants);
        if (!this.applicationProperties.devMode()) {
            cities.remove("public");
        }
        return cities;
    }

    @Bean
    public LocalValidatorFactoryBean entityValidator() {
        return new LocalValidatorFactoryBean();
    }

    @Bean
    public ReportService reportService() {
        return new JasperReportService(10, 30);
    }
}

