/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.service;

import org.egov.infra.admin.master.entity.Action;
import org.egov.infra.admin.master.entity.Feature;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.service.ActionService;
import org.egov.infra.admin.master.service.FeatureService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FeatureAccessControlService {
    @Autowired
    private FeatureService featureService;
    @Autowired
    private ActionService actionService;

    @Transactional
    public void grantAccess(Feature feature, Role role) {
        for (Action action : feature.getActions()) {
            action.addRole(role);
            this.actionService.saveAction(action);
        }
        feature.addRole(role);
        this.featureService.saveFeature(feature);
    }

    @Transactional
    public void revokeAccess(Feature feature, Role role) {
        for (Action action : feature.getActions()) {
            if (this.featureService.getNumberOfFeatureByRoleAction(role, action) != 1L) continue;
            action.removeRole(role);
            this.actionService.saveAction(action);
        }
        feature.removeRole(role);
        this.featureService.saveFeature(feature);
    }
}

