/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.aadhaar.webservice.client;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import org.egov.infra.aadhaar.webservice.contract.AadhaarInfo;
import org.egov.infra.config.properties.ApplicationProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.w3c.dom.Node;

@Service
public class AadhaarInfoServiceClient {
    @Autowired
    private ApplicationProperties applicationProperties;

    public AadhaarInfo getAadhaarInfo(String uid) throws Exception {
        SOAPConnection soapConnection = SOAPConnectionFactory.newInstance().createConnection();
        String wsdlURL = this.applicationProperties.getProperty("aadhaar.wsdl.url");
        String aadhaarInfoMethod = this.applicationProperties.getProperty("aadhaar.info.ws.method");
        AadhaarInfo aahaarInfo = this.retriveAadhaarInfo(soapConnection.call(this.soapRequest(aadhaarInfoMethod, uid), (Object)wsdlURL));
        soapConnection.close();
        return aahaarInfo;
    }

    private SOAPMessage soapRequest(String methodName, String uid) throws Exception {
        SOAPMessage soapMessage = MessageFactory.newInstance().createMessage();
        SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
        soapEnvelope.addNamespaceDeclaration("end", this.applicationProperties.getProperty("aadhaar.info.ws.namespace"));
        soapEnvelope.getBody().addChildElement(methodName, "end").addChildElement("arg0").addTextNode(uid);
        soapMessage.saveChanges();
        return soapMessage;
    }

    private AadhaarInfo retriveAadhaarInfo(SOAPMessage soapResponseMessage) throws Exception {
        Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{Class.forName(this.applicationProperties.getProperty("aadhaar.info.ws.client.impl.class.fqn"))}).createUnmarshaller();
        return (AadhaarInfo)unmarshaller.unmarshal((Node)soapResponseMessage.getSOAPBody().extractContentAsDocument());
    }
}

