/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infstr.security.spring.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.config.security.authentication.SecureUser;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

public class EgovAuthenticationProcessingFilter
extends UsernamePasswordAuthenticationFilter {
    private List<String> credentialFields = new ArrayList<String>();

    public void setCredentialFields(List<String> credentialFields) {
        this.credentialFields = credentialFields;
    }

    protected void setDetails(HttpServletRequest request, UsernamePasswordAuthenticationToken authToken) {
        authToken.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain, Authentication authResult) throws IOException, ServletException {
        String location = request.getParameter("locationId");
        HttpSession session = request.getSession();
        if (StringUtils.isNotBlank((CharSequence)location)) {
            session.setAttribute("locationId", (Object)location);
        }
        if (authResult != null) {
            SecureUser principal = (SecureUser)authResult.getPrincipal();
            session.setAttribute("userid", (Object)principal.getUserId());
            session.setAttribute("username", (Object)principal.getUsername());
        }
        super.successfulAuthentication(request, response, filterChain, authResult);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, String> credentials = new HashMap<String, String>();
        for (String credential : this.credentialFields) {
            String field = request.getParameter(credential) == null ? "" : request.getParameter(credential);
            credentials.put(credential, field);
        }
        String username = request.getParameter("j_username");
        UsernamePasswordAuthenticationToken authToken = new UsernamePasswordAuthenticationToken((Object)username, credentials);
        request.getSession().setAttribute("j_username", (Object)username);
        this.setDetails(request, authToken);
        return this.getAuthenticationManager().authenticate((Authentication)authToken);
    }
}

