/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.struts.actions.workflow;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.workflow.entity.WorkflowTypes;
import org.egov.infra.workflow.matrix.entity.WorkFlowAdditionalRule;
import org.egov.infra.workflow.matrix.service.WorkFlowAdditionalDetailsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParentPackage(value="egov")
public class WorkFlowAdditionalDetailsAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    public WorkFlowAdditionalRule wfAdditionalRule = new WorkFlowAdditionalRule();
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkFlowAdditionalDetailsAction.class);
    private List<WorkflowTypes> objectList = new ArrayList<WorkflowTypes>();
    private WorkFlowAdditionalDetailsService workFlowAdditionalDetailsService;
    private List<String> buttonList = new ArrayList<String>();
    private List<String> statusList = new ArrayList<String>();
    private List<String> stateList = new ArrayList<String>();
    private List<String> actionList = new ArrayList<String>();
    private Long objectType;
    private String additionalRules;
    private String mode;
    private List<WorkFlowAdditionalRule> additionalRuleList = new ArrayList<WorkFlowAdditionalRule>();

    public List<WorkFlowAdditionalRule> getAdditionalRuleList() {
        return this.additionalRuleList;
    }

    public void setAdditionalRuleList(List<WorkFlowAdditionalRule> additionalRuleList) {
        this.additionalRuleList = additionalRuleList;
    }

    public String getAdditionalRules() {
        return this.additionalRules;
    }

    public void setAdditionalRules(String additionalRules) {
        this.additionalRules = additionalRules;
    }

    public Long getObjectType() {
        return this.objectType;
    }

    public void setObjectType(Long objectType) {
        this.objectType = objectType;
    }

    public List<String> getButtonList() {
        return this.buttonList;
    }

    public void setButtonList(List<String> buttonList) {
        this.buttonList = buttonList;
    }

    public List<String> getStateList() {
        return this.stateList;
    }

    public void setStateList(List<String> stateList) {
        this.stateList = stateList;
    }

    public List<String> getActionList() {
        return this.actionList;
    }

    public void setActionList(List<String> actionList) {
        this.actionList = actionList;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public WorkFlowAdditionalDetailsService getWorkFlowAdditionalDetailsService() {
        return this.workFlowAdditionalDetailsService;
    }

    public void setWorkFlowAdditionalDetailsService(WorkFlowAdditionalDetailsService workFlowAdditionalDetailsService) {
        this.workFlowAdditionalDetailsService = workFlowAdditionalDetailsService;
    }

    public WorkFlowAdditionalRule getWfAdditionalRule() {
        return this.wfAdditionalRule;
    }

    public void setWfAdditionalRule(WorkFlowAdditionalRule wfAdditionalRule) {
        this.wfAdditionalRule = wfAdditionalRule;
    }

    public WorkFlowAdditionalDetailsAction() {
        this.addRelatedEntity("objecttypeid", WorkflowTypes.class);
    }

    @Override
    public void prepare() {
        LOGGER.info("Prepare Method is called");
        super.prepare();
        this.objectList = this.workFlowAdditionalDetailsService.getobjectTypeList();
        this.statusList = this.workFlowAdditionalDetailsService.getAllModuleTypeforStatus();
        if (this.getObjectType() != null && !this.getObjectType().equals("-1") && !this.getObjectType().equals("")) {
            this.additionalRuleList = this.workFlowAdditionalDetailsService.getAdditionalRulesbyObject(this.getObjectType());
        }
        this.addDropdownData("objectTypeList", this.objectList);
        this.addDropdownData("statusList", this.statusList);
        this.addDropdownData("additionalRuleList", this.additionalRuleList);
        LOGGER.info("Prepare Method is ended");
    }

    public Object getModel() {
        return this.wfAdditionalRule;
    }

    public String newForm() {
        return "search";
    }

    public String buildWorkFlowDetails() {
        LOGGER.info("BuildWorkFlowDetails Method is called");
        this.buttonList.add("Approve");
        this.buttonList.add("Reject");
        this.actionList.add("END");
        LOGGER.info("BuildWorkFlowDetails Method is ended");
        return "new";
    }

    public String create() {
        LOGGER.info("create Method is called");
        if (this.wfAdditionalRule.getObjecttypeid() == null) {
            this.addActionError("Please Select ObjectType");
        }
        if (this.wfAdditionalRule.getAdditionalRule() == null && this.wfAdditionalRule.getAdditionalRule().equals("-1")) {
            this.setAdditionalRules(null);
        }
        WorkFlowAdditionalRule additionalRuleobj = null;
        additionalRuleobj = this.wfAdditionalRule.getId() == null ? this.workFlowAdditionalDetailsService.getObjectbyTypeandRule(this.wfAdditionalRule.getObjecttypeid().getId(), this.wfAdditionalRule.getAdditionalRule()) : this.workFlowAdditionalDetailsService.getObjectbyTypeandRule(this.wfAdditionalRule.getId(), this.wfAdditionalRule.getObjecttypeid().getId(), this.wfAdditionalRule.getAdditionalRule());
        if (additionalRuleobj != null) {
            this.addActionError("Details already present for the objecttype and additional rule");
            return "new";
        }
        this.setStateActionandButtonforObject();
        this.workFlowAdditionalDetailsService.save(this.wfAdditionalRule);
        this.setStateActionandButtonListforDisplay();
        this.setMode("view");
        LOGGER.info("create Method is ended");
        return "new";
    }

    public String view() {
        LOGGER.info("view Method is called");
        if (this.getObjectType() == null) {
            this.addActionError("Please Select ObjectType");
        }
        if (this.getAdditionalRules() == null && this.getAdditionalRules().equals("-1")) {
            this.setAdditionalRules(null);
        }
        this.wfAdditionalRule = this.workFlowAdditionalDetailsService.getObjectbyTypeandRule(this.getObjectType(), this.getAdditionalRules());
        if (this.wfAdditionalRule == null) {
            this.addActionError("No details found for the objecttype");
            return "search";
        }
        this.setStateActionandButtonListforDisplay();
        this.setMode("view");
        LOGGER.info("view Method is ended");
        return "new";
    }

    public String modify() {
        LOGGER.info("modify Method is Started");
        if (this.getObjectType() == null) {
            this.addActionError("Please Select ObjectType");
        }
        if (this.getAdditionalRules() == null || this.getAdditionalRules().equals("-1")) {
            this.setAdditionalRules(null);
        }
        this.wfAdditionalRule = this.workFlowAdditionalDetailsService.getObjectbyTypeandRule(this.getObjectType(), this.getAdditionalRules());
        if (this.wfAdditionalRule == null) {
            this.addActionError("No details found for the objecttype");
            return "search";
        }
        this.setStateActionandButtonListforDisplay();
        this.setMode("modify");
        LOGGER.info("modify Method is ended");
        return "new";
    }

    public void setStateActionandButtonforObject() {
        LOGGER.info("setStateActionandButtonforObject Method is Started");
        StringBuffer statestr = new StringBuffer();
        if (this.getStateList() != null) {
            for (String statename : this.getStateList()) {
                statename = statename.trim();
                if (new String(statestr).toUpperCase().contains(statename.toUpperCase())) continue;
                statestr.append(statename);
                statestr.append(",");
            }
        }
        String statestring = new String(statestr).substring(0, statestr.length() - 1);
        this.wfAdditionalRule.setStates(statestring);
        StringBuffer actionstr = new StringBuffer();
        if (this.getActionList() != null) {
            for (String actionname : this.getActionList()) {
                actionname = actionname.trim();
                if (new String(actionstr).toUpperCase().contains(actionname.toUpperCase())) continue;
                actionstr.append(actionname);
                actionstr.append(",");
            }
        }
        String actionstring = new String(actionstr).substring(0, actionstr.length() - 1);
        this.wfAdditionalRule.setWorkFlowActions(actionstring);
        StringBuffer buttonstr = new StringBuffer();
        if (this.getButtonList() != null) {
            for (String butname : this.getButtonList()) {
                butname = butname.trim();
                if (new String(buttonstr).toUpperCase().contains(butname.toUpperCase())) continue;
                buttonstr.append(butname);
                buttonstr.append(",");
            }
        }
        String buttonstring = new String(buttonstr).substring(0, buttonstr.length() - 1);
        this.wfAdditionalRule.setButtons(buttonstring);
        LOGGER.info("setStateActionandButtonforObject Method is Ended");
    }

    public void setStateActionandButtonListforDisplay() {
        LOGGER.info("setStateActionandButtonListforDisplay Method is Started");
        if (this.wfAdditionalRule != null) {
            ArrayList<String> statesList = new ArrayList<String>();
            if (this.wfAdditionalRule.getStates() != null) {
                StringTokenizer strngtkn = new StringTokenizer(this.wfAdditionalRule.getStates(), ",");
                while (strngtkn.hasMoreTokens()) {
                    String statetkn = strngtkn.nextToken();
                    if (statesList.contains(statetkn)) continue;
                    statesList.add(statetkn);
                }
                if (statesList.size() != 0) {
                    this.setStateList(statesList);
                }
            }
            ArrayList<String> actionsList = new ArrayList<String>();
            if (this.wfAdditionalRule.getWorkFlowActions() != null) {
                StringTokenizer strngtkn = new StringTokenizer(this.wfAdditionalRule.getWorkFlowActions(), ",");
                while (strngtkn.hasMoreTokens()) {
                    String statetkn = strngtkn.nextToken();
                    if (actionsList.contains(statetkn)) continue;
                    actionsList.add(statetkn);
                }
                if (actionsList.size() != 0) {
                    this.setActionList(actionsList);
                }
            }
            ArrayList<String> buttonList = new ArrayList<String>();
            if (this.wfAdditionalRule.getButtons() != null) {
                StringTokenizer strngtkn = new StringTokenizer(this.wfAdditionalRule.getButtons(), ",");
                while (strngtkn.hasMoreTokens()) {
                    String statetkn = strngtkn.nextToken();
                    if (buttonList.contains(statetkn)) continue;
                    buttonList.add(statetkn);
                }
                if (buttonList.size() != 0) {
                    this.setButtonList(buttonList);
                }
            }
        }
        LOGGER.info("setStateActionandButtonListforDisplay Method is Ended");
    }

    public String getAdditionalRulesforObject() {
        this.additionalRuleList = this.workFlowAdditionalDetailsService.getAdditionalRulesbyObject(this.getObjectType());
        return "additionalRule";
    }
}

