/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.utils;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.json.simple.JSONObject;

public class StringUtils
extends org.apache.commons.lang.StringUtils {
    public static final Pattern SPL_CHAR_PATRN = Pattern.compile("([&;,+=\\[\\]\\{\\}><^\\(\\)#:~`/\\\\!'\"])");

    public static String escapeSpecialChars(String str) {
        return str.replaceAll("\\s\\s+|\\r\\n", "<br/>").replaceAll("'", "\\\\'");
    }

    public static String escapeJavaScript(String str) {
        return StringEscapeUtils.escapeJavaScript((String)str);
    }

    public static String escapeJSON(String str) {
        return JSONObject.escape((String)str);
    }

    public static boolean hasSpecialChars(String str) {
        Matcher matcher = SPL_CHAR_PATRN.matcher(str);
        return matcher.find();
    }

    public static String emptyIfNull(String value) {
        return value == null ? "" : value;
    }

    public static String[] toStringArray(String ... values) {
        return values;
    }

    public static List<String> toList(String ... values) {
        return Arrays.asList(values);
    }

    public static String encodeString(String string) {
        return org.apache.commons.lang3.StringUtils.toEncodedString((byte[])string.getBytes(), (Charset)Charset.forName("UTF-8"));
    }

    public static String[] listToStringArray(List<String> values) {
        return (String[])values.stream().toArray(String[]::new);
    }
}

