/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.utils;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonSerializer;
import java.util.Collection;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.web.support.json.adapter.HibernateProxyTypeAdapter;

public class JsonUtils {
    private JsonUtils() {
    }

    public static <T> String toJSON(Collection<T> objects, Class<? extends T> objectClazz, Class<? extends JsonSerializer<T>> adptorClazz) {
        try {
            return new GsonBuilder().registerTypeAdapterFactory(HibernateProxyTypeAdapter.FACTORY).registerTypeAdapter(objectClazz, adptorClazz.newInstance()).create().toJson(objects);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ApplicationRuntimeException("Could not convert object list to json string", e);
        }
    }

    public static <T> String toJSON(T object, Class<? extends JsonSerializer<T>> adptorClazz) {
        try {
            return new GsonBuilder().registerTypeAdapterFactory(HibernateProxyTypeAdapter.FACTORY).registerTypeAdapter(object.getClass(), adptorClazz.newInstance()).create().toJson(object);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ApplicationRuntimeException("Could not convert object to json string", e);
        }
    }

    public static <T> T fromJSON(String json, Class<T> clazz) {
        return (T)new GsonBuilder().create().fromJson(json, clazz);
    }
}

