/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.egov.infra.config.core.GlobalSettings;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.utils.NumberToWord;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.Years;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public final class DateUtils
extends org.apache.commons.lang3.time.DateUtils {
    private static final String DEFAULT_YEAR_PATTERN = "yyyy";
    private static final Map<String, DateTimeFormatter> DATE_FORMATTER_HOLDER = new ConcurrentHashMap<String, DateTimeFormatter>(3);
    private static final String[] DATE_IN_WORDS = new String[]{"First", "Second", "Third", "Fourth", "Fifth", "Sixth", "Seventh", "Eighth", "Ninth", "Tenth", "Eleventh", "Twelfth", "Thirteenth", "Fourteenth", "Fifteenth", "Sixteenth", "Seventeenth", "Eighteenth", "Nineteenth", "Twentieth", "Twenty first", "Twenty second", "Twenty third", "Twenty fourth", "Twenty fifth", "Twenty sixth", "Twenty seventh", "Twenty eighth", "Twenty ninth", "Thirtieth", "Thirty first"};

    private DateUtils() {
    }

    public static String currentDateToYearFormat() {
        return DateUtils.toYearFormat(new LocalDate());
    }

    public static String toYearFormat(LocalDate date) {
        return DateUtils.formatter(DEFAULT_YEAR_PATTERN).print((ReadablePartial)date);
    }

    public static String toYearFormat(Date date) {
        return DateUtils.toYearFormat(new LocalDate((Object)date));
    }

    public static String currentDateToDefaultDateFormat() {
        return DateUtils.toDefaultDateFormat(new LocalDate());
    }

    public static String toDefaultDateFormat(LocalDate date) {
        return DateUtils.formatter(GlobalSettings.defaultDatePattern()).print((ReadablePartial)date);
    }

    public static String toDefaultDateFormat(Date date) {
        return DateUtils.toDefaultDateFormat(new LocalDate((Object)date));
    }

    public static DateTime toDateTimeUsingDefaultPattern(String date) {
        return DateUtils.formatter(GlobalSettings.defaultDatePattern()).parseDateTime(date);
    }

    public static Date toDateUsingDefaultPattern(String date) {
        return DateUtils.toDateTimeUsingDefaultPattern(date).toDate();
    }

    public static String toDefaultDateTimeFormat(Date date) {
        return DateUtils.formatter(GlobalSettings.defaultDateTimePattern()).print((ReadableInstant)new DateTime((Object)date));
    }

    public static Date endOfDay(Date date) {
        return DateUtils.endOfGivenDate(new DateTime((Object)date)).toDate();
    }

    public static DateTime endOfToday() {
        return DateUtils.endOfGivenDate(new DateTime());
    }

    public static DateTime endOfGivenDate(DateTime dateTime) {
        return dateTime.millisOfDay().withMaximumValue();
    }

    public static DateTime startOfGivenDate(DateTime dateTime) {
        return dateTime.withTimeAtStartOfDay();
    }

    public static Date startOfDay(Date date) {
        return DateUtils.startOfGivenDate(new DateTime((Object)date)).toDate();
    }

    public static int noOfMonthsBetween(Date startDate, Date endDate) {
        return DateUtils.monthsBetween(new LocalDate((Object)startDate), new LocalDate((Object)endDate));
    }

    public static int monthsBetween(LocalDate startDate, LocalDate endDate) {
        return Months.monthsBetween((ReadablePartial)startDate, (ReadablePartial)endDate).getMonths();
    }

    public static int daysBetween(Date startDate, Date endDate) {
        return DateUtils.daysBetween(new LocalDate((Object)startDate), new LocalDate((Object)endDate));
    }

    public static int daysBetween(LocalDate startDate, LocalDate endDate) {
        return Days.daysBetween((ReadablePartial)startDate, (ReadablePartial)endDate).getDays();
    }

    public static int noOfYearsBetween(Date startDate, Date endDate) {
        return Years.yearsBetween((ReadablePartial)new LocalDate((Object)startDate), (ReadablePartial)new LocalDate((Object)endDate)).getYears();
    }

    public static Date add(Date inputDate, int addType, int addAmount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(inputDate);
        calendar.add(addType, addAmount);
        return calendar.getTime();
    }

    public static boolean compareDates(Date firstDate, Date secondDate) {
        return firstDate == null || secondDate == null || !firstDate.before(secondDate);
    }

    public static Date[] constructDateRange(Date fromDate, Date toDate) {
        Date[] dates = new Date[2];
        Calendar calfrom = Calendar.getInstance();
        calfrom.setTime(fromDate);
        calfrom.set(10, 0);
        calfrom.set(12, 0);
        calfrom.set(13, 0);
        calfrom.set(9, 0);
        dates[0] = calfrom.getTime();
        Calendar calto = Calendar.getInstance();
        calto.setTime(toDate);
        calto.set(10, 0);
        calto.set(12, 0);
        calto.set(13, 0);
        calto.add(5, 1);
        dates[1] = calto.getTime();
        return dates;
    }

    public static Date createDate(int year) {
        Calendar date = Calendar.getInstance();
        date.set(1, year);
        date.set(2, 0);
        date.set(5, 1);
        return date.getTime();
    }

    public static Map<Integer, String> getAllMonths() {
        HashMap<Integer, String> monthMap = new HashMap<Integer, String>();
        monthMap.put(1, "Jan");
        monthMap.put(2, "Feb");
        monthMap.put(3, "Mar");
        monthMap.put(4, "Apr");
        monthMap.put(5, "May");
        monthMap.put(6, "Jun");
        monthMap.put(7, "July");
        monthMap.put(8, "Aug");
        monthMap.put(9, "Sep");
        monthMap.put(10, "Oct");
        monthMap.put(11, "Nov");
        monthMap.put(12, "Dec");
        return monthMap;
    }

    public static Map<Integer, String> getAllMonthsWithFullNames() {
        HashMap<Integer, String> monthMap = new HashMap<Integer, String>();
        monthMap.put(1, "January");
        monthMap.put(2, "Feburary");
        monthMap.put(3, "March");
        monthMap.put(4, "April");
        monthMap.put(5, "May");
        monthMap.put(6, "June");
        monthMap.put(7, "July");
        monthMap.put(8, "August");
        monthMap.put(9, "September");
        monthMap.put(10, "October");
        monthMap.put(11, "November");
        monthMap.put(12, "December");
        return monthMap;
    }

    public static Date getDate(String date, String pattern) {
        try {
            return StringUtils.isNotBlank((String)date) && StringUtils.isNotBlank((String)pattern) ? DateUtils.getDateFormatter(pattern).parse(date) : null;
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Date or Pattern value is not valid", e);
        }
    }

    public static Date getDate(int year, int month, int date) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, date);
        return calendar.getTime();
    }

    public static String getDefaultFormattedDate(Date date) {
        return DateUtils.toDefaultDateFormat(date);
    }

    public static String getFormattedDate(Date date, String pattern) {
        return DateUtils.formatter(pattern).print((ReadableInstant)new DateTime((Object)date));
    }

    public static Date now() {
        return new Date();
    }

    public static Date today() {
        Calendar calendar = Calendar.getInstance();
        return DateUtils.getDate(calendar.get(1), calendar.get(2), calendar.get(5));
    }

    public static Date tomorrow() {
        return new DateTime().plusDays(1).toDate();
    }

    public static String convertToWords(Date dateToConvert) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateToConvert);
        StringBuilder dateInWord = new StringBuilder();
        dateInWord.append(DATE_IN_WORDS[cal.get(5) - 1]).append(' ');
        dateInWord.append(DateUtils.formatter("dd-MMMMM-yyyy").print((ReadableInstant)new DateTime((Object)dateToConvert)).split("-")[1]).append(' ');
        dateInWord.append(NumberToWord.translateToWord(String.valueOf(cal.get(1))));
        return dateInWord.toString();
    }

    public static boolean between(Date date, Date fromDate, Date toDate) {
        return (date.after(fromDate) || date.equals(fromDate)) && date.before(toDate) || date.equals(toDate);
    }

    public static Map<Integer, String> getAllFinancialYearMonthsWithFullNames() {
        HashMap<Integer, String> monthMap = new HashMap<Integer, String>();
        monthMap.put(1, "April");
        monthMap.put(2, "May");
        monthMap.put(3, "June");
        monthMap.put(4, "July");
        monthMap.put(5, "August");
        monthMap.put(6, "September");
        monthMap.put(7, "October");
        monthMap.put(8, "November");
        monthMap.put(9, "December");
        monthMap.put(10, "January");
        monthMap.put(11, "Feburary");
        monthMap.put(12, "March");
        return monthMap;
    }

    public static SimpleDateFormat getDateFormatter(String pattern) {
        return new SimpleDateFormat(pattern, GlobalSettings.locale());
    }

    public static DateTimeFormatter defaultDateFormatter() {
        return DateUtils.formatter(GlobalSettings.defaultDatePattern());
    }

    public static DateTimeFormatter formatter(String pattern) {
        DateTimeFormatter formatter = DATE_FORMATTER_HOLDER.get(pattern);
        if (formatter == null) {
            formatter = DateTimeFormat.forPattern((String)pattern).withLocale(GlobalSettings.locale());
            DATE_FORMATTER_HOLDER.putIfAbsent(pattern, formatter);
        }
        return formatter;
    }
}

