/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.persistence.validator;

import java.util.Date;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.validator.annotation.CompareDates;

public class CompareDatesValidator
implements ConstraintValidator<CompareDates, Object> {
    private CompareDates compareDates;

    public void initialize(CompareDates compareDates) {
        this.compareDates = compareDates;
    }

    public boolean isValid(Object target, ConstraintValidatorContext validatorContext) {
        try {
            boolean isValid;
            Date fromDate = (Date)FieldUtils.readField((Object)target, (String)this.compareDates.fromDate(), (boolean)true);
            Date toDate = (Date)FieldUtils.readField((Object)target, (String)this.compareDates.toDate(), (boolean)true);
            boolean bl = isValid = fromDate != null && toDate != null && fromDate.before(toDate);
            if (!isValid) {
                validatorContext.buildConstraintViolationWithTemplate(this.compareDates.message()).addPropertyNode(this.compareDates.toDate()).addConstraintViolation();
            }
            return isValid;
        }
        catch (IllegalAccessException e) {
            throw new ApplicationRuntimeException("Could not compare dates", e);
        }
    }
}

