/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.elasticsearch.service.es;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.config.mapper.BeanMapperConfiguration;
import org.egov.infra.elasticsearch.entity.ApplicationIndex;
import org.egov.infra.elasticsearch.entity.bean.ApplicationDetails;
import org.egov.infra.elasticsearch.entity.bean.ApplicationIndexRequest;
import org.egov.infra.elasticsearch.entity.bean.ApplicationIndexResponse;
import org.egov.infra.elasticsearch.entity.bean.ApplicationInfo;
import org.egov.infra.elasticsearch.entity.bean.ServiceDetails;
import org.egov.infra.elasticsearch.entity.bean.ServiceGroupDetails;
import org.egov.infra.elasticsearch.entity.bean.ServiceGroupTrend;
import org.egov.infra.elasticsearch.entity.bean.SourceTrend;
import org.egov.infra.elasticsearch.entity.bean.Trend;
import org.egov.infra.elasticsearch.entity.es.ApplicationDocument;
import org.egov.infra.elasticsearch.repository.es.ApplicationDocumentRepository;
import org.egov.infra.utils.DateUtils;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.aggregations.metrics.sum.Sum;
import org.elasticsearch.search.aggregations.metrics.valuecount.ValueCount;
import org.elasticsearch.search.aggregations.metrics.valuecount.ValueCountBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ApplicationDocumentService {
    private static final String OWNER_NAME = "ownerName";
    private static final String CITY_CODE = "cityCode";
    private static final String CITY_GRADE = "cityGrade";
    private static final String APPLICATION_DATE = "applicationDate";
    private static final String CITY_NAME = "cityName";
    private static final String SOURCE_SYSTEM = "SYSTEM";
    private static final String SOURCE_ONLINE = "ONLINE";
    private static final String SOURCE_MEESEVA = "MEESEVA";
    private static final String SOURCE_CSC = "CSC";
    private static final String SLA_GAP = "slaGap";
    private static final String OTHERS_TOTAL = "othersTotal";
    private static final String ULB_TOTAL = "ulbTotal";
    private static final String ONLINE_TOTAL = "onlineTotal";
    private static final String MEESEVA_TOTAL = "meesevaTotal";
    private static final String CSC_TOTAL = "cscTotal";
    private static final String SLAB4BEYOND_SLA = "slab4beyondSLA";
    private static final String SLAB3BEYOND_SLA = "slab3beyondSLA";
    private static final String SLAB2BEYOND_SLA = "slab2beyondSLA";
    private static final String SLAB1BEYOND_SLA = "slab1beyondSLA";
    private static final String OPEN_BEYOND_SLA = "openBeyondSLA";
    private static final String OPEN_WITHIN_SLA = "openWithinSLA";
    private static final String CLOSED_BEYOND_SLA = "closedBeyondSLA";
    private static final String CLOSED_WITHIN_SLA = "closedWithinSLA";
    private static final String CHANNEL = "channel";
    private static final String APPLICATION_TYPE = "applicationType";
    private static final String REGION_NAME = "regionName";
    private static final String MODULE_NAME = "moduleName";
    private static final String APPLICATION_NUMBER = "applicationNumber";
    private static final String APPLICATIONS_INDEX = "applications";
    private static final String IS_CLOSED = "isClosed";
    private static final String DATE_AGGR = "date_aggr";
    private static final String DISTRICT_NAME = "districtName";
    private static final String OPEN = "open";
    private static final String CLOSED = "closed";
    private static final String RECEIVED = "received";
    private static final String TOTAL_COUNT = "total_count";
    private static final String TOTAL_BEYOND_SLA = "totalBeyondSLA";
    private static final String TOTAL_WITHIN_SLA = "totalWithinSLA";
    private static final String MODULE_PROPERTY_TAX = "Property Tax";
    private static final String MODULE_WATER_TAX = "Water Charges";
    private static final String MODULE_TRADE_LICENSE = "Trade License";
    private static final String MODULE_ADVERTISEMENT_TAX = "Advertisement Tax";
    private static final String MODULE_MARRIAGE_REGISTRATION = "Marriage Registration";
    private static final String SLA = "sla";
    private final ApplicationDocumentRepository applicationDocumentRepository;
    @Autowired
    private BeanMapperConfiguration beanMapperConfiguration;
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;
    private static final String DATE_FORMAT_YYYYMMDD = "yyyy-MM-dd";
    private static final SimpleDateFormat DATEFORMATTER_YYYY_MM_DD = new SimpleDateFormat("yyyy-MM-dd");

    @Autowired
    public ApplicationDocumentService(ApplicationDocumentRepository applicationDocumentRepository) {
        this.applicationDocumentRepository = applicationDocumentRepository;
    }

    @Transactional
    public ApplicationDocument createOrUpdateApplicationDocument(ApplicationIndex applicationIndex) {
        ApplicationDocument applicationDocument = (ApplicationDocument)this.beanMapperConfiguration.map(applicationIndex, ApplicationDocument.class);
        return (ApplicationDocument)this.applicationDocumentRepository.save(applicationDocument);
    }

    public ApplicationIndexResponse findAllApplications(ApplicationIndexRequest applicationIndexRequest) {
        ValueCount valueCount;
        Aggregations aggregation;
        ApplicationIndexResponse applicationIndexResponse = new ApplicationIndexResponse();
        Date fromDate = null;
        Date toDate = null;
        if (StringUtils.isNotBlank((CharSequence)applicationIndexRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)applicationIndexRequest.getToDate())) {
            fromDate = DateUtils.getDate(applicationIndexRequest.getFromDate(), DATE_FORMAT_YYYYMMDD);
            toDate = DateUtils.addDays((Date)DateUtils.getDate(applicationIndexRequest.getToDate(), DATE_FORMAT_YYYYMMDD), (int)1);
        }
        if ((aggregation = this.getDocumentCounts(applicationIndexRequest, fromDate, toDate, "", RECEIVED, "", 0)) != null) {
            valueCount = (ValueCount)aggregation.get(TOTAL_COUNT);
            applicationIndexResponse.setTotalReceived(valueCount != null ? valueCount.getValue() : 0L);
        }
        if ((aggregation = this.getDocumentCounts(applicationIndexRequest, fromDate, toDate, "", CLOSED, "", 0)) != null) {
            valueCount = (ValueCount)aggregation.get(TOTAL_COUNT);
            applicationIndexResponse.setTotalClosed(valueCount != null ? valueCount.getValue() : 0L);
        }
        if ((aggregation = this.getDocumentCounts(applicationIndexRequest, fromDate, toDate, "", OPEN, "", 0)) != null) {
            valueCount = (ValueCount)aggregation.get(TOTAL_COUNT);
            applicationIndexResponse.setTotalOpen(valueCount != null ? valueCount.getValue() : 0L);
        }
        if ((aggregation = this.getDocumentCounts(applicationIndexRequest, fromDate = new Date(), toDate = DateUtils.addDays((Date)new Date(), (int)1), "", CLOSED, "", 0)) != null) {
            valueCount = (ValueCount)aggregation.get(TOTAL_COUNT);
            applicationIndexResponse.setTodaysClosed(valueCount != null ? valueCount.getValue() : 0L);
        }
        if ((aggregation = this.getDocumentCounts(applicationIndexRequest, fromDate, toDate, "", RECEIVED, "", 0)) != null) {
            valueCount = (ValueCount)aggregation.get(TOTAL_COUNT);
            applicationIndexResponse.setTodaysReceived(valueCount != null ? valueCount.getValue() : 0L);
        }
        List<Trend> applicationTrends = this.getMonthwiseApplicationTrends(applicationIndexRequest);
        applicationIndexResponse.setTrend(applicationTrends);
        List<ApplicationDetails> applicationDetails = this.getAnalysisTableResponse(applicationIndexRequest);
        applicationIndexResponse.setDetails(applicationDetails);
        return applicationIndexResponse;
    }

    public ApplicationIndexResponse findServiceGroupWiseApplications(ApplicationIndexRequest applicationIndexRequest) {
        ValueCount valueCount;
        StringTerms aggr;
        Aggregations aggregation;
        ApplicationIndexResponse applicationIndexResponse = new ApplicationIndexResponse();
        Date fromDate = null;
        Date toDate = null;
        ArrayList<ServiceGroupDetails> serviceGroups = new ArrayList<ServiceGroupDetails>();
        if (StringUtils.isNotBlank((CharSequence)applicationIndexRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)applicationIndexRequest.getToDate())) {
            fromDate = DateUtils.getDate(applicationIndexRequest.getFromDate(), DATE_FORMAT_YYYYMMDD);
            toDate = DateUtils.addDays((Date)DateUtils.getDate(applicationIndexRequest.getToDate(), DATE_FORMAT_YYYYMMDD), (int)1);
        }
        if ((aggregation = this.getDocumentCounts(applicationIndexRequest, fromDate, toDate, MODULE_NAME, RECEIVED, MODULE_NAME, 0)) != null) {
            aggr = (StringTerms)aggregation.get(MODULE_NAME);
            for (Terms.Bucket entry : aggr.getBuckets()) {
                ServiceGroupDetails serviceGroup = new ServiceGroupDetails();
                valueCount = (ValueCount)entry.getAggregations().get(TOTAL_COUNT);
                serviceGroup.setServiceGroup(String.valueOf(entry.getKey()));
                serviceGroup.setTotalReceived(valueCount.getValue());
                serviceGroups.add(serviceGroup);
            }
        }
        if ((aggregation = this.getDocumentCounts(applicationIndexRequest, fromDate, toDate, MODULE_NAME, OPEN, MODULE_NAME, 0)) != null) {
            aggr = (StringTerms)aggregation.get(MODULE_NAME);
            block1: for (Terms.Bucket entry : aggr.getBuckets()) {
                String moduleName = String.valueOf(entry.getKey());
                for (ServiceGroupDetails serviceGroup : serviceGroups) {
                    if (!serviceGroup.getServiceGroup().equals(moduleName)) continue;
                    valueCount = (ValueCount)entry.getAggregations().get(TOTAL_COUNT);
                    serviceGroup.setTotalOpen(valueCount.getValue());
                    continue block1;
                }
            }
        }
        applicationIndexResponse.setServiceGroupDetails(serviceGroups);
        List<ServiceGroupTrend> serviceGroupTrend = this.getMonthwiseServiceGroupApplicationTrends(applicationIndexRequest);
        applicationIndexResponse.setServiceGroupTrend(serviceGroupTrend);
        return applicationIndexResponse;
    }

    public List<ServiceGroupTrend> getMonthwiseServiceGroupApplicationTrends(ApplicationIndexRequest applicationIndexRequest) {
        Date fromDate = null;
        Date toDate = null;
        Map<Integer, String> monthValuesMap = DateUtils.getAllMonthsWithFullNames();
        ArrayList<ServiceGroupTrend> receivedApplications = new ArrayList<ServiceGroupTrend>();
        if (StringUtils.isNotBlank((CharSequence)applicationIndexRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)applicationIndexRequest.getToDate())) {
            fromDate = DateUtils.getDate(applicationIndexRequest.getFromDate(), DATE_FORMAT_YYYYMMDD);
            toDate = DateUtils.addDays((Date)DateUtils.getDate(applicationIndexRequest.getToDate(), DATE_FORMAT_YYYYMMDD), (int)1);
        }
        Aggregations aggregation = this.getMonthwiseServiceGroupApplications(applicationIndexRequest, fromDate, toDate, RECEIVED);
        Histogram aggr = (Histogram)aggregation.get(DATE_AGGR);
        this.prepareMonthwiseServiceGroupDetails(monthValuesMap, receivedApplications, aggr);
        return receivedApplications;
    }

    public ApplicationIndexResponse findSourceWiseApplicationDetails(ApplicationIndexRequest applicationIndexRequest) {
        ValueCount valueCount;
        Aggregations aggregation;
        ApplicationIndexResponse applicationIndexResponse = new ApplicationIndexResponse();
        Date fromDate = null;
        Date toDate = null;
        if (StringUtils.isNotBlank((CharSequence)applicationIndexRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)applicationIndexRequest.getToDate())) {
            fromDate = DateUtils.getDate(applicationIndexRequest.getFromDate(), DATE_FORMAT_YYYYMMDD);
            toDate = DateUtils.addDays((Date)DateUtils.getDate(applicationIndexRequest.getToDate(), DATE_FORMAT_YYYYMMDD), (int)1);
        }
        if ((aggregation = this.getDocumentCounts(applicationIndexRequest, fromDate, toDate, "", RECEIVED, "", 0)) != null) {
            valueCount = (ValueCount)aggregation.get(TOTAL_COUNT);
            applicationIndexResponse.setTotalReceived(valueCount != null ? valueCount.getValue() : 0L);
        }
        if ((aggregation = this.getDocumentCounts(applicationIndexRequest, fromDate, toDate, "", MEESEVA_TOTAL, "", 0)) != null) {
            valueCount = (ValueCount)aggregation.get(TOTAL_COUNT);
            applicationIndexResponse.setTotalMeeseva(valueCount != null ? valueCount.getValue() : 0L);
        }
        if ((aggregation = this.getDocumentCounts(applicationIndexRequest, fromDate, toDate, "", CSC_TOTAL, "", 0)) != null) {
            valueCount = (ValueCount)aggregation.get(TOTAL_COUNT);
            applicationIndexResponse.setTotalCsc(valueCount != null ? valueCount.getValue() : 0L);
        }
        if ((aggregation = this.getDocumentCounts(applicationIndexRequest, fromDate, toDate, "", ULB_TOTAL, "", 0)) != null) {
            valueCount = (ValueCount)aggregation.get(TOTAL_COUNT);
            applicationIndexResponse.setTotalUlb(valueCount != null ? valueCount.getValue() : 0L);
        }
        if ((aggregation = this.getDocumentCounts(applicationIndexRequest, fromDate, toDate, "", ONLINE_TOTAL, "", 0)) != null) {
            valueCount = (ValueCount)aggregation.get(TOTAL_COUNT);
            applicationIndexResponse.setTotalOnline(valueCount != null ? valueCount.getValue() : 0L);
        }
        if ((aggregation = this.getDocumentCounts(applicationIndexRequest, fromDate, toDate, "", OTHERS_TOTAL, "", 0)) != null) {
            valueCount = (ValueCount)aggregation.get(TOTAL_COUNT);
            applicationIndexResponse.setTotalOthers(valueCount != null ? valueCount.getValue() : 0L);
        }
        List<SourceTrend> sourceTrend = this.getMonthwiseSourceApplicationTrends(applicationIndexRequest);
        applicationIndexResponse.setSourceTrend(sourceTrend);
        return applicationIndexResponse;
    }

    public List<SourceTrend> getMonthwiseSourceApplicationTrends(ApplicationIndexRequest applicationIndexRequest) {
        Date fromDate = null;
        Date toDate = null;
        Map<Integer, String> monthValuesMap = DateUtils.getAllMonthsWithFullNames();
        ArrayList<SourceTrend> receivedApplications = new ArrayList<SourceTrend>();
        if (StringUtils.isNotBlank((CharSequence)applicationIndexRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)applicationIndexRequest.getToDate())) {
            fromDate = DateUtils.getDate(applicationIndexRequest.getFromDate(), DATE_FORMAT_YYYYMMDD);
            toDate = DateUtils.addDays((Date)DateUtils.getDate(applicationIndexRequest.getToDate(), DATE_FORMAT_YYYYMMDD), (int)1);
        }
        Aggregations aggregation = this.getMonthwiseSourceApplications(applicationIndexRequest, fromDate, toDate, RECEIVED);
        Histogram aggr = (Histogram)aggregation.get(DATE_AGGR);
        this.prepareMonthwiseSourceDetails(monthValuesMap, receivedApplications, aggr);
        return receivedApplications;
    }

    private void prepareMonthwiseSourceDetails(Map<Integer, String> monthValuesMap, List<SourceTrend> applications, Histogram aggr) {
        for (Histogram.Bucket entry : aggr.getBuckets()) {
            SourceTrend sourceTrend = new SourceTrend();
            String[] dateArr = entry.getKeyAsString().split("T");
            Integer month = Integer.valueOf(dateArr[0].split("-", 3)[1]);
            String monthName = monthValuesMap.get(month);
            StringTerms termAggr = (StringTerms)entry.getAggregations().get(CHANNEL);
            for (Terms.Bucket term : termAggr.getBuckets()) {
                this.populateTotal(sourceTrend, term, term.getKeyAsString());
            }
            sourceTrend.setMonth(monthName);
            applications.add(sourceTrend);
        }
    }

    private void populateTotal(SourceTrend sourceTrend, Terms.Bucket term, String channel) {
        ValueCount countAggr = (ValueCount)term.getAggregations().get(TOTAL_COUNT);
        if (SOURCE_CSC.equals(channel)) {
            sourceTrend.setTotalCsc(countAggr.getValue());
        } else if (SOURCE_MEESEVA.equals(channel)) {
            sourceTrend.setTotalMeeseva(countAggr.getValue());
        } else if (SOURCE_SYSTEM.equals(channel)) {
            sourceTrend.setTotalUlb(countAggr.getValue());
        } else if (SOURCE_ONLINE.equals(channel)) {
            sourceTrend.setTotalOnline(countAggr.getValue());
        } else {
            sourceTrend.setTotalOthers(countAggr.getValue());
        }
    }

    private Aggregations getMonthwiseSourceApplications(ApplicationIndexRequest applicationIndexRequest, Date fromDate, Date toDate, String status) {
        BoolQueryBuilder boolQuery = this.prepareWhereClause(applicationIndexRequest, fromDate, toDate);
        if (CLOSED.equalsIgnoreCase(status)) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)IS_CLOSED, (Object)1));
        } else if (OPEN.equalsIgnoreCase(status)) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)IS_CLOSED, (Object)0));
        }
        DateHistogramBuilder aggregationBuilder = ((DateHistogramBuilder)AggregationBuilders.dateHistogram((String)DATE_AGGR).field(APPLICATION_DATE)).interval(DateHistogramInterval.MONTH);
        aggregationBuilder.subAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)CHANNEL).field(CHANNEL)).subAggregation((AbstractAggregationBuilder)AggregationBuilders.count((String)TOTAL_COUNT).field(APPLICATION_NUMBER)));
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{APPLICATIONS_INDEX}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)aggregationBuilder).build();
        return (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, response -> response.getAggregations());
    }

    private void prepareMonthwiseServiceGroupDetails(Map<Integer, String> monthValuesMap, List<ServiceGroupTrend> applications, Histogram aggr) {
        for (Histogram.Bucket entry : aggr.getBuckets()) {
            ServiceGroupTrend serviceGroupTrend = new ServiceGroupTrend();
            String[] dateArr = entry.getKeyAsString().split("T");
            Integer month = Integer.valueOf(dateArr[0].split("-", 3)[1]);
            String monthName = monthValuesMap.get(month);
            StringTerms termAggr = (StringTerms)entry.getAggregations().get(MODULE_NAME);
            ArrayList<ServiceGroupDetails> serviceGroupDetails = new ArrayList<ServiceGroupDetails>();
            for (Terms.Bucket term : termAggr.getBuckets()) {
                ServiceGroupDetails details = new ServiceGroupDetails();
                ValueCount countAggr = (ValueCount)term.getAggregations().get(TOTAL_COUNT);
                details.setServiceGroup(term.getKeyAsString());
                details.setTotalReceived(countAggr.getValue());
                serviceGroupDetails.add(details);
            }
            serviceGroupTrend.setMonth(monthName);
            serviceGroupTrend.setServiceGroupDetails(serviceGroupDetails);
            applications.add(serviceGroupTrend);
        }
    }

    private BoolQueryBuilder prepareWhereClause(ApplicationIndexRequest applicationIndexRequest, Date fromDate, Date toDate) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.matchQuery((String)APPLICATION_NUMBER, (Object)""));
        if (StringUtils.isNotBlank((CharSequence)applicationIndexRequest.getRegion())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)REGION_NAME, (Object)applicationIndexRequest.getRegion()));
        }
        if (StringUtils.isNotBlank((CharSequence)applicationIndexRequest.getDistrict())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)DISTRICT_NAME, (Object)applicationIndexRequest.getDistrict()));
        }
        if (StringUtils.isNotBlank((CharSequence)applicationIndexRequest.getGrade())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)CITY_GRADE, (Object)applicationIndexRequest.getGrade()));
        }
        if (StringUtils.isNotBlank((CharSequence)applicationIndexRequest.getUlbCode())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)CITY_CODE, (Object)applicationIndexRequest.getUlbCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)applicationIndexRequest.getServiceGroup())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)MODULE_NAME, (Object)applicationIndexRequest.getServiceGroup()));
        }
        if (StringUtils.isNotBlank((CharSequence)applicationIndexRequest.getService())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)APPLICATION_TYPE, (Object)applicationIndexRequest.getService()));
        }
        if (StringUtils.isNotBlank((CharSequence)applicationIndexRequest.getSource())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)CHANNEL, (Object)applicationIndexRequest.getSource()));
        }
        if (fromDate != null && toDate != null) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)APPLICATION_DATE).gte(DATEFORMATTER_YYYY_MM_DD.format(fromDate)).lte(DATEFORMATTER_YYYY_MM_DD.format(toDate)).includeUpper(false));
        }
        if (StringUtils.isNotBlank((CharSequence)applicationIndexRequest.getFunctionaryCode())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)OWNER_NAME, (Object)applicationIndexRequest.getFunctionaryCode()));
            if (StringUtils.isNotBlank((CharSequence)applicationIndexRequest.getClosed())) {
                boolQuery = "Y".equalsIgnoreCase(applicationIndexRequest.getClosed()) ? boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)IS_CLOSED, (Object)1)) : boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)IS_CLOSED, (Object)0));
            }
            if (StringUtils.isNotBlank((CharSequence)applicationIndexRequest.getBeyondSLA())) {
                boolQuery = this.filterBasedOnSLAForFunctionary(applicationIndexRequest, boolQuery);
            }
        }
        return boolQuery;
    }

    private BoolQueryBuilder filterBasedOnSLAForFunctionary(ApplicationIndexRequest applicationIndexRequest, BoolQueryBuilder boolQuery) {
        BoolQueryBuilder slaQuery = boolQuery;
        slaQuery = "Y".equalsIgnoreCase(applicationIndexRequest.getBeyondSLA()) ? (StringUtils.isNotBlank((CharSequence)applicationIndexRequest.getAgeing()) ? ("0-1Wdays".equalsIgnoreCase(applicationIndexRequest.getAgeing()) ? slaQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)SLA_GAP).gte(1).lt(8)) : ("1W-1M".equalsIgnoreCase(applicationIndexRequest.getAgeing()) ? slaQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)SLA_GAP).gte(8).lt(31)) : ("1M-3M".equalsIgnoreCase(applicationIndexRequest.getAgeing()) ? slaQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)SLA_GAP).gte(31).lt(91)) : slaQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)SLA_GAP).gte(91))))) : slaQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)SLA_GAP).gt(0))) : slaQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)SLA_GAP).lte(0));
        return slaQuery;
    }

    private Map<String, Long> getAggregationWiseApplicationCounts(ApplicationIndexRequest applicationIndexRequest, Date fromDate, Date toDate, String aggregationName, String status, String aggregationField, int size) {
        HashMap<String, Long> aggregationResults = new HashMap<String, Long>();
        Aggregations aggregation = this.getDocumentCounts(applicationIndexRequest, fromDate, toDate, aggregationName, status, aggregationField, size);
        StringTerms cityAggr = (StringTerms)aggregation.get(aggregationName);
        for (Terms.Bucket entry : cityAggr.getBuckets()) {
            ValueCount valueCount = (ValueCount)entry.getAggregations().get(TOTAL_COUNT);
            aggregationResults.put(String.valueOf(entry.getKey()), valueCount.getValue());
        }
        return aggregationResults;
    }

    private List<ApplicationDetails> getAnalysisTableResponse(ApplicationIndexRequest applicationIndexRequest) {
        ArrayList<ApplicationDetails> applicationDetailsList = new ArrayList<ApplicationDetails>();
        Date fromDate = null;
        Date toDate = null;
        String aggregationField = DISTRICT_NAME;
        int size = 15;
        Map detailsForAggregationField = Collections.emptyMap();
        Map<Object, Object> delayDaysMap = new HashMap();
        LinkedHashMap moduleWiseDetailsMap = new LinkedHashMap();
        if (StringUtils.isNotBlank((CharSequence)applicationIndexRequest.getAggregationLevel())) {
            Map<String, String> aggrTypeAndSize = this.fetchAggregationTypeAndSize(applicationIndexRequest.getAggregationLevel());
            aggregationField = aggrTypeAndSize.get("aggregationField");
            size = Integer.parseInt(aggrTypeAndSize.get("size"));
        }
        if (StringUtils.isNotBlank((CharSequence)applicationIndexRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)applicationIndexRequest.getToDate())) {
            fromDate = DateUtils.getDate(applicationIndexRequest.getFromDate(), DATE_FORMAT_YYYYMMDD);
            toDate = DateUtils.addDays((Date)DateUtils.getDate(applicationIndexRequest.getToDate(), DATE_FORMAT_YYYYMMDD), (int)1);
        }
        Map<String, Long> totalRcvdApplications = this.getAggregationWiseApplicationCounts(applicationIndexRequest, fromDate, toDate, "totalReceived", RECEIVED, aggregationField, size);
        Map<String, Long> totalClosedApplications = this.getAggregationWiseApplicationCounts(applicationIndexRequest, fromDate, toDate, "totalClosed", CLOSED, aggregationField, size);
        Map<String, Long> totalOpenApplications = this.getAggregationWiseApplicationCounts(applicationIndexRequest, fromDate, toDate, "totalOpen", OPEN, aggregationField, size);
        Map<String, Long> closedWithinSLAApplications = this.getAggregationWiseApplicationCounts(applicationIndexRequest, fromDate, toDate, CLOSED_WITHIN_SLA, CLOSED_WITHIN_SLA, aggregationField, size);
        Map<String, Long> closedBeyondSLAApplications = this.getAggregationWiseApplicationCounts(applicationIndexRequest, fromDate, toDate, CLOSED_BEYOND_SLA, CLOSED_BEYOND_SLA, aggregationField, size);
        Map<String, Long> openWithinSLAApplications = this.getAggregationWiseApplicationCounts(applicationIndexRequest, fromDate, toDate, OPEN_WITHIN_SLA, OPEN_WITHIN_SLA, aggregationField, size);
        Map<String, Long> openBeyondSLAApplications = this.getAggregationWiseApplicationCounts(applicationIndexRequest, fromDate, toDate, OPEN_BEYOND_SLA, OPEN_BEYOND_SLA, aggregationField, size);
        Map<String, Long> slab1beyondSLAApplications = this.getAggregationWiseApplicationCounts(applicationIndexRequest, fromDate, toDate, SLAB1BEYOND_SLA, SLAB1BEYOND_SLA, aggregationField, size);
        Map<String, Long> slab2beyondSLAApplications = this.getAggregationWiseApplicationCounts(applicationIndexRequest, fromDate, toDate, SLAB2BEYOND_SLA, SLAB2BEYOND_SLA, aggregationField, size);
        Map<String, Long> slab3beyondSLAApplications = this.getAggregationWiseApplicationCounts(applicationIndexRequest, fromDate, toDate, SLAB3BEYOND_SLA, SLAB3BEYOND_SLA, aggregationField, size);
        Map<String, Long> slab4beyondSLAApplications = this.getAggregationWiseApplicationCounts(applicationIndexRequest, fromDate, toDate, SLAB4BEYOND_SLA, SLAB4BEYOND_SLA, aggregationField, size);
        Map<String, Long> cscApplications = this.getAggregationWiseApplicationCounts(applicationIndexRequest, fromDate, toDate, CSC_TOTAL, CSC_TOTAL, aggregationField, size);
        Map<String, Long> meesevaApplications = this.getAggregationWiseApplicationCounts(applicationIndexRequest, fromDate, toDate, MEESEVA_TOTAL, MEESEVA_TOTAL, aggregationField, size);
        Map<String, Long> onlineApplications = this.getAggregationWiseApplicationCounts(applicationIndexRequest, fromDate, toDate, ONLINE_TOTAL, ONLINE_TOTAL, aggregationField, size);
        Map<String, Long> ulbApplications = this.getAggregationWiseApplicationCounts(applicationIndexRequest, fromDate, toDate, ULB_TOTAL, ULB_TOTAL, aggregationField, size);
        Map<String, Long> otherApplications = this.getAggregationWiseApplicationCounts(applicationIndexRequest, fromDate, toDate, OTHERS_TOTAL, OTHERS_TOTAL, aggregationField, size);
        if (APPLICATION_TYPE.equalsIgnoreCase(aggregationField) || OWNER_NAME.equalsIgnoreCase(aggregationField)) {
            delayDaysMap = this.getDelayedDaysAggregate(applicationIndexRequest, fromDate, toDate, aggregationField, size);
        }
        for (Map.Entry<String, Long> entry : totalRcvdApplications.entrySet()) {
            ApplicationDetails applicationDetails = new ApplicationDetails();
            String name = entry.getKey();
            if (DISTRICT_NAME.equalsIgnoreCase(aggregationField) || CITY_NAME.equalsIgnoreCase(aggregationField) || APPLICATION_TYPE.equalsIgnoreCase(aggregationField) || OWNER_NAME.equalsIgnoreCase(aggregationField)) {
                detailsForAggregationField = this.getDetailsForAggregationType(applicationIndexRequest, fromDate, toDate, name, aggregationField);
            }
            if (DISTRICT_NAME.equalsIgnoreCase(aggregationField)) {
                applicationDetails.setDistrict(name);
                if (!detailsForAggregationField.isEmpty()) {
                    applicationDetails.setRegion(detailsForAggregationField.get(REGION_NAME).toString());
                }
            } else if (REGION_NAME.equalsIgnoreCase(aggregationField)) {
                applicationDetails.setRegion(name);
            } else if (CITY_NAME.equalsIgnoreCase(aggregationField)) {
                applicationDetails.setUlbName(name);
                if (!detailsForAggregationField.isEmpty()) {
                    applicationDetails.setRegion(detailsForAggregationField.get(REGION_NAME).toString());
                    applicationDetails.setDistrict(detailsForAggregationField.get(DISTRICT_NAME).toString());
                    applicationDetails.setGrade(detailsForAggregationField.get(CITY_GRADE).toString());
                    applicationDetails.setUlbCode(detailsForAggregationField.get(CITY_CODE).toString());
                }
            } else if (APPLICATION_TYPE.equalsIgnoreCase(aggregationField)) {
                applicationDetails.setServiceType(name);
                if (!detailsForAggregationField.isEmpty()) {
                    applicationDetails.setServiceGroup(detailsForAggregationField.get(MODULE_NAME).toString());
                    applicationDetails.setSlaPeriod((Integer)detailsForAggregationField.get(SLA));
                }
                if (!delayDaysMap.isEmpty() && delayDaysMap.get(name) != null) {
                    applicationDetails.setDelayedDays((Long)delayDaysMap.get(name));
                }
            } else if (CITY_GRADE.equalsIgnoreCase(aggregationField)) {
                applicationDetails.setGrade(name);
            } else if (MODULE_NAME.equalsIgnoreCase(aggregationField)) {
                applicationDetails.setServiceGroup(name);
            } else if (CHANNEL.equalsIgnoreCase(aggregationField)) {
                applicationDetails.setSource(name);
            } else if (OWNER_NAME.equalsIgnoreCase(aggregationField)) {
                applicationDetails.setFunctionaryName(name);
                if (StringUtils.isNotBlank((CharSequence)applicationIndexRequest.getService())) {
                    applicationDetails.setServiceType(applicationIndexRequest.getService());
                }
                if (!detailsForAggregationField.isEmpty()) {
                    applicationDetails.setUlbName(detailsForAggregationField.get(CITY_NAME).toString());
                    applicationDetails.setSlaPeriod((Integer)detailsForAggregationField.get(SLA));
                }
                if (!delayDaysMap.isEmpty() && delayDaysMap.get(name) != null) {
                    applicationDetails.setDelayedDays((Long)delayDaysMap.get(name));
                }
            }
            applicationDetails.setTotalReceived(entry.getValue());
            applicationDetails.setTotalClosed(totalClosedApplications.get(name) == null ? 0L : totalClosedApplications.get(name));
            applicationDetails.setTotalOpen(totalOpenApplications.get(name) == null ? 0L : totalOpenApplications.get(name));
            applicationDetails.setClosedWithinSLA(closedWithinSLAApplications.get(name) == null ? 0L : closedWithinSLAApplications.get(name));
            applicationDetails.setClosedBeyondSLA(closedBeyondSLAApplications.get(name) == null ? 0L : closedBeyondSLAApplications.get(name));
            applicationDetails.setOpenWithinSLA(openWithinSLAApplications.get(name) == null ? 0L : openWithinSLAApplications.get(name));
            applicationDetails.setOpenBeyondSLA(openBeyondSLAApplications.get(name) == null ? 0L : openBeyondSLAApplications.get(name));
            applicationDetails.setSlab1beyondSLA(slab1beyondSLAApplications.get(name) == null ? 0L : slab1beyondSLAApplications.get(name));
            applicationDetails.setSlab2beyondSLA(slab2beyondSLAApplications.get(name) == null ? 0L : slab2beyondSLAApplications.get(name));
            applicationDetails.setSlab3beyondSLA(slab3beyondSLAApplications.get(name) == null ? 0L : slab3beyondSLAApplications.get(name));
            applicationDetails.setSlab4beyondSLA(slab4beyondSLAApplications.get(name) == null ? 0L : slab4beyondSLAApplications.get(name));
            applicationDetails.setCscTotal(cscApplications.get(name) == null ? 0L : cscApplications.get(name));
            applicationDetails.setMeesevaTotal(meesevaApplications.get(name) == null ? 0L : meesevaApplications.get(name));
            applicationDetails.setOnlineTotal(onlineApplications.get(name) == null ? 0L : onlineApplications.get(name));
            applicationDetails.setUlbTotal(ulbApplications.get(name) == null ? 0L : ulbApplications.get(name));
            applicationDetails.setOthersTotal(otherApplications.get(name) == null ? 0L : otherApplications.get(name));
            if (APPLICATION_TYPE.equalsIgnoreCase(aggregationField)) {
                if (moduleWiseDetailsMap.get(applicationDetails.getServiceGroup()) == null) {
                    ArrayList<ApplicationDetails> modulewiseDetails = new ArrayList<ApplicationDetails>();
                    modulewiseDetails.add(applicationDetails);
                    moduleWiseDetailsMap.put(applicationDetails.getServiceGroup(), modulewiseDetails);
                    continue;
                }
                ((List)moduleWiseDetailsMap.get(applicationDetails.getServiceGroup())).add(applicationDetails);
                continue;
            }
            applicationDetailsList.add(applicationDetails);
        }
        if (APPLICATION_TYPE.equalsIgnoreCase(aggregationField)) {
            if (moduleWiseDetailsMap.get(MODULE_PROPERTY_TAX) != null) {
                applicationDetailsList.addAll((Collection)moduleWiseDetailsMap.get(MODULE_PROPERTY_TAX));
            }
            if (moduleWiseDetailsMap.get(MODULE_WATER_TAX) != null) {
                applicationDetailsList.addAll((Collection)moduleWiseDetailsMap.get(MODULE_WATER_TAX));
            }
            if (moduleWiseDetailsMap.get(MODULE_TRADE_LICENSE) != null) {
                applicationDetailsList.addAll((Collection)moduleWiseDetailsMap.get(MODULE_TRADE_LICENSE));
            }
            if (moduleWiseDetailsMap.get(MODULE_ADVERTISEMENT_TAX) != null) {
                applicationDetailsList.addAll((Collection)moduleWiseDetailsMap.get(MODULE_ADVERTISEMENT_TAX));
            }
            if (moduleWiseDetailsMap.get(MODULE_MARRIAGE_REGISTRATION) != null) {
                applicationDetailsList.addAll((Collection)moduleWiseDetailsMap.get(MODULE_MARRIAGE_REGISTRATION));
            }
        }
        return applicationDetailsList;
    }

    private Map<String, String> fetchAggregationTypeAndSize(String aggregationLevel) {
        HashMap<String, String> aggrTypeAndSize = new HashMap<String, String>();
        String aggregationField = DISTRICT_NAME;
        int size = 15;
        if ("region".equalsIgnoreCase(aggregationLevel)) {
            aggregationField = REGION_NAME;
            size = 4;
        } else if ("district".equalsIgnoreCase(aggregationLevel)) {
            aggregationField = DISTRICT_NAME;
            size = 15;
        } else if ("grade".equalsIgnoreCase(aggregationLevel)) {
            aggregationField = CITY_GRADE;
            size = 7;
        } else if ("ulb".equalsIgnoreCase(aggregationLevel)) {
            aggregationField = CITY_NAME;
            size = 112;
        } else if ("module".equalsIgnoreCase(aggregationLevel)) {
            aggregationField = MODULE_NAME;
            size = 6;
        } else if ("service".equalsIgnoreCase(aggregationLevel)) {
            aggregationField = APPLICATION_TYPE;
            size = 27;
        } else if ("source".equalsIgnoreCase(aggregationLevel)) {
            aggregationField = CHANNEL;
            size = 5;
        } else if ("functionary".equalsIgnoreCase(aggregationLevel)) {
            aggregationField = OWNER_NAME;
            size = 1000;
        }
        aggrTypeAndSize.put("aggregationField", aggregationField);
        aggrTypeAndSize.put("size", String.valueOf(size));
        return aggrTypeAndSize;
    }

    public List<Trend> getMonthwiseApplicationTrends(ApplicationIndexRequest applicationIndexRequest) {
        ArrayList<Trend> trendsList = new ArrayList<Trend>();
        Date fromDate = null;
        Date toDate = null;
        Map<Integer, String> monthValuesMap = DateUtils.getAllMonthsWithFullNames();
        LinkedHashMap<String, Long> receivedApplications = new LinkedHashMap<String, Long>();
        LinkedHashMap<String, Long> closedApplications = new LinkedHashMap<String, Long>();
        LinkedHashMap<String, Long> openApplications = new LinkedHashMap<String, Long>();
        if (StringUtils.isNotBlank((CharSequence)applicationIndexRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)applicationIndexRequest.getToDate())) {
            fromDate = DateUtils.getDate(applicationIndexRequest.getFromDate(), DATE_FORMAT_YYYYMMDD);
            toDate = DateUtils.addDays((Date)DateUtils.getDate(applicationIndexRequest.getToDate(), DATE_FORMAT_YYYYMMDD), (int)1);
        }
        Aggregations aggregation = this.getMonthwiseApplications(applicationIndexRequest, fromDate, toDate, RECEIVED);
        Histogram dateaggs = (Histogram)aggregation.get(DATE_AGGR);
        this.prepareMonthwiseDetails(monthValuesMap, receivedApplications, dateaggs);
        aggregation = this.getMonthwiseApplications(applicationIndexRequest, fromDate, toDate, CLOSED);
        dateaggs = (Histogram)aggregation.get(DATE_AGGR);
        this.prepareMonthwiseDetails(monthValuesMap, closedApplications, dateaggs);
        aggregation = this.getMonthwiseApplications(applicationIndexRequest, fromDate, toDate, OPEN);
        dateaggs = (Histogram)aggregation.get(DATE_AGGR);
        this.prepareMonthwiseDetails(monthValuesMap, openApplications, dateaggs);
        if (StringUtils.isBlank((CharSequence)applicationIndexRequest.getFromDate()) && StringUtils.isBlank((CharSequence)applicationIndexRequest.getToDate())) {
            for (Map.Entry<Integer, String> entry : DateUtils.getAllFinancialYearMonthsWithFullNames().entrySet()) {
                Trend trend = new Trend();
                trend.setMonth(entry.getValue());
                trend.setTotalReceived(receivedApplications.get(entry.getValue()) == null ? 0L : (Long)receivedApplications.get(entry.getValue()));
                trend.setTotalClosed(closedApplications.get(entry.getValue()) == null ? 0L : (Long)closedApplications.get(entry.getValue()));
                trend.setTotalOpen(openApplications.get(entry.getValue()) == null ? 0L : (Long)openApplications.get(entry.getValue()));
                trendsList.add(trend);
            }
        } else {
            for (Map.Entry entry : receivedApplications.entrySet()) {
                Trend trend = new Trend();
                trend.setMonth((String)entry.getKey());
                trend.setTotalReceived(receivedApplications.get(entry.getKey()) == null ? 0L : (Long)receivedApplications.get(entry.getKey()));
                trend.setTotalClosed(closedApplications.get(entry.getKey()) == null ? 0L : (Long)closedApplications.get(entry.getKey()));
                trend.setTotalOpen(openApplications.get(entry.getKey()) == null ? 0L : (Long)openApplications.get(entry.getKey()));
                trendsList.add(trend);
            }
        }
        return trendsList;
    }

    private void prepareMonthwiseDetails(Map<Integer, String> monthValuesMap, Map<String, Long> applications, Histogram dateaggs) {
        for (Histogram.Bucket entry : dateaggs.getBuckets()) {
            String[] dateArr = entry.getKeyAsString().split("T");
            Integer month = Integer.valueOf(dateArr[0].split("-", 3)[1]);
            String monthName = monthValuesMap.get(month);
            ValueCount countAggr = (ValueCount)entry.getAggregations().get(TOTAL_COUNT);
            applications.put(monthName, countAggr.getValue());
        }
    }

    private Aggregations getMonthwiseApplications(ApplicationIndexRequest applicationIndexRequest, Date fromDate, Date toDate, String status) {
        BoolQueryBuilder boolQuery = this.prepareWhereClause(applicationIndexRequest, fromDate, toDate);
        if (CLOSED.equalsIgnoreCase(status)) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)IS_CLOSED, (Object)1));
        } else if (OPEN.equalsIgnoreCase(status)) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)IS_CLOSED, (Object)0));
        }
        AggregationBuilder aggregationBuilder = ((DateHistogramBuilder)AggregationBuilders.dateHistogram((String)DATE_AGGR).field(APPLICATION_DATE)).interval(DateHistogramInterval.MONTH).subAggregation((AbstractAggregationBuilder)AggregationBuilders.count((String)TOTAL_COUNT).field(APPLICATION_NUMBER));
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{APPLICATIONS_INDEX}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)aggregationBuilder).build();
        return (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, response -> response.getAggregations());
    }

    private Aggregations getMonthwiseServiceGroupApplications(ApplicationIndexRequest applicationIndexRequest, Date fromDate, Date toDate, String status) {
        BoolQueryBuilder boolQuery = this.prepareWhereClause(applicationIndexRequest, fromDate, toDate);
        if (CLOSED.equalsIgnoreCase(status)) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)IS_CLOSED, (Object)1));
        } else if (OPEN.equalsIgnoreCase(status)) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)IS_CLOSED, (Object)0));
        }
        DateHistogramBuilder aggregationBuilder = ((DateHistogramBuilder)AggregationBuilders.dateHistogram((String)DATE_AGGR).field(APPLICATION_DATE)).interval(DateHistogramInterval.MONTH);
        aggregationBuilder.subAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)MODULE_NAME).field(MODULE_NAME)).subAggregation((AbstractAggregationBuilder)AggregationBuilders.count((String)TOTAL_COUNT).field(APPLICATION_NUMBER)));
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{APPLICATIONS_INDEX}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)aggregationBuilder).build();
        return (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, response -> response.getAggregations());
    }

    private Aggregations getDocumentCounts(ApplicationIndexRequest applicationIndexRequest, Date fromDate, Date toDate, String aggregationName, String applicationStatus, String aggregationField, int size) {
        AggregationBuilder aggregation = null;
        ValueCountBuilder countBuilder = (ValueCountBuilder)AggregationBuilders.count((String)TOTAL_COUNT).field(APPLICATION_NUMBER);
        BoolQueryBuilder boolQuery = this.prepareWhereClause(applicationIndexRequest, fromDate, toDate);
        if (StringUtils.isNotBlank((CharSequence)applicationStatus)) {
            boolQuery = this.prepareQueryForApplicationStatus(applicationStatus, boolQuery);
        }
        if (StringUtils.isNotBlank((CharSequence)aggregationName)) {
            aggregation = ((TermsBuilder)AggregationBuilders.terms((String)aggregationName).field(aggregationField)).size(size).subAggregation((AbstractAggregationBuilder)countBuilder);
        }
        NativeSearchQueryBuilder queryBuilder = new NativeSearchQueryBuilder().withIndices(new String[]{APPLICATIONS_INDEX}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)countBuilder);
        NativeSearchQuery searchQueryColl = StringUtils.isNotBlank((CharSequence)aggregationName) ? queryBuilder.addAggregation((AbstractAggregationBuilder)aggregation).build() : queryBuilder.build();
        return (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, response -> response.getAggregations());
    }

    private BoolQueryBuilder prepareQueryForApplicationStatus(String applicationStatus, BoolQueryBuilder boolQuery) {
        BoolQueryBuilder appStatusQuery = boolQuery;
        if (CLOSED.equalsIgnoreCase(applicationStatus)) {
            appStatusQuery = appStatusQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)IS_CLOSED, (Object)1));
        } else if (OPEN.equalsIgnoreCase(applicationStatus)) {
            appStatusQuery = appStatusQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)IS_CLOSED, (Object)0));
        } else if (CLOSED_WITHIN_SLA.equalsIgnoreCase(applicationStatus)) {
            appStatusQuery = appStatusQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)IS_CLOSED, (Object)1)).must((QueryBuilder)QueryBuilders.rangeQuery((String)SLA_GAP).lte(0));
        } else if (CLOSED_BEYOND_SLA.equalsIgnoreCase(applicationStatus)) {
            appStatusQuery = appStatusQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)IS_CLOSED, (Object)1)).must((QueryBuilder)QueryBuilders.rangeQuery((String)SLA_GAP).gt(0));
        } else if (TOTAL_BEYOND_SLA.equalsIgnoreCase(applicationStatus)) {
            appStatusQuery = appStatusQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)SLA_GAP).gt(0));
        } else if (TOTAL_WITHIN_SLA.equalsIgnoreCase(applicationStatus)) {
            appStatusQuery = appStatusQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)SLA_GAP).lte(0));
        } else if (OPEN_WITHIN_SLA.equalsIgnoreCase(applicationStatus)) {
            appStatusQuery = appStatusQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)IS_CLOSED, (Object)0)).must((QueryBuilder)QueryBuilders.rangeQuery((String)SLA_GAP).lte(0));
        } else if (OPEN_BEYOND_SLA.equalsIgnoreCase(applicationStatus)) {
            appStatusQuery = appStatusQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)IS_CLOSED, (Object)0)).must((QueryBuilder)QueryBuilders.rangeQuery((String)SLA_GAP).gt(0));
        } else if (SLAB1BEYOND_SLA.equalsIgnoreCase(applicationStatus)) {
            appStatusQuery = appStatusQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)SLA_GAP).gte(1).lt(8));
        } else if (SLAB2BEYOND_SLA.equalsIgnoreCase(applicationStatus)) {
            appStatusQuery = appStatusQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)SLA_GAP).gte(8).lt(31));
        } else if (SLAB3BEYOND_SLA.equalsIgnoreCase(applicationStatus)) {
            appStatusQuery = appStatusQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)SLA_GAP).gte(31).lt(91));
        } else if (SLAB4BEYOND_SLA.equalsIgnoreCase(applicationStatus)) {
            appStatusQuery = appStatusQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)SLA_GAP).gte(91));
        } else if (CSC_TOTAL.equalsIgnoreCase(applicationStatus)) {
            appStatusQuery = appStatusQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)CHANNEL, (Object)SOURCE_CSC));
        } else if (MEESEVA_TOTAL.equalsIgnoreCase(applicationStatus)) {
            appStatusQuery = appStatusQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)CHANNEL, (Object)SOURCE_MEESEVA));
        } else if (ONLINE_TOTAL.equalsIgnoreCase(applicationStatus)) {
            appStatusQuery = appStatusQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)CHANNEL, (Object)SOURCE_ONLINE));
        } else if (ULB_TOTAL.equalsIgnoreCase(applicationStatus)) {
            appStatusQuery = appStatusQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)CHANNEL, (Object)SOURCE_SYSTEM));
        } else if (OTHERS_TOTAL.equalsIgnoreCase(applicationStatus)) {
            appStatusQuery = appStatusQuery.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)CHANNEL, Arrays.asList(SOURCE_CSC, SOURCE_MEESEVA, SOURCE_ONLINE, SOURCE_SYSTEM)));
        }
        return appStatusQuery;
    }

    private Map getDetailsForAggregationType(ApplicationIndexRequest applicationIndexRequest, Date fromDate, Date toDate, String value, String aggregationField) {
        String[] requiredFields = null;
        BoolQueryBuilder boolQuery = this.prepareWhereClause(applicationIndexRequest, fromDate, toDate);
        if (DISTRICT_NAME.equalsIgnoreCase(aggregationField)) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)DISTRICT_NAME, (Object)value));
            requiredFields = new String[]{REGION_NAME};
        } else if (CITY_NAME.equalsIgnoreCase(aggregationField)) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)CITY_NAME, (Object)value));
            requiredFields = new String[]{REGION_NAME, DISTRICT_NAME, CITY_GRADE, CITY_CODE};
        } else if (APPLICATION_TYPE.equalsIgnoreCase(aggregationField)) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)APPLICATION_TYPE, (Object)value));
            requiredFields = new String[]{MODULE_NAME, SLA};
        } else if (OWNER_NAME.equalsIgnoreCase(aggregationField)) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)OWNER_NAME, (Object)value));
            requiredFields = new String[]{CITY_NAME, SLA};
        }
        Map applicationTypeDetails = new HashMap();
        SearchResponse response = (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{APPLICATIONS_INDEX}).setQuery((QueryBuilder)boolQuery).setSize(1).setFetchSource(requiredFields, null).execute().actionGet();
        for (SearchHit hit : response.getHits()) {
            applicationTypeDetails = hit.sourceAsMap();
        }
        return applicationTypeDetails;
    }

    public ApplicationIndexResponse findServiceWiseDetails(ApplicationIndexRequest applicationIndexRequest) {
        ValueCount valueCount;
        Aggregations aggregation;
        ApplicationIndexResponse applicationIndexResponse = new ApplicationIndexResponse();
        Date fromDate = null;
        Date toDate = null;
        if (StringUtils.isNotBlank((CharSequence)applicationIndexRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)applicationIndexRequest.getToDate())) {
            fromDate = DateUtils.getDate(applicationIndexRequest.getFromDate(), DATE_FORMAT_YYYYMMDD);
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)DateUtils.getDate(applicationIndexRequest.getToDate(), DATE_FORMAT_YYYYMMDD), (int)1);
        }
        if ((aggregation = this.getDocumentCounts(applicationIndexRequest, fromDate, toDate, "", RECEIVED, "", 0)) != null) {
            valueCount = (ValueCount)aggregation.get(TOTAL_COUNT);
            applicationIndexResponse.setTotalReceived(valueCount != null ? valueCount.getValue() : 0L);
        }
        if ((aggregation = this.getDocumentCounts(applicationIndexRequest, fromDate, toDate, "", CLOSED, "", 0)) != null) {
            valueCount = (ValueCount)aggregation.get(TOTAL_COUNT);
            applicationIndexResponse.setTotalClosed(valueCount != null ? valueCount.getValue() : 0L);
        }
        if ((aggregation = this.getDocumentCounts(applicationIndexRequest, fromDate, toDate, "", OPEN, "", 0)) != null) {
            valueCount = (ValueCount)aggregation.get(TOTAL_COUNT);
            applicationIndexResponse.setTotalOpen(valueCount != null ? valueCount.getValue() : 0L);
        }
        if ((aggregation = this.getDocumentCounts(applicationIndexRequest, fromDate, toDate, "", TOTAL_BEYOND_SLA, "", 0)) != null) {
            valueCount = (ValueCount)aggregation.get(TOTAL_COUNT);
            applicationIndexResponse.setTotalBeyondSLA(valueCount != null ? valueCount.getValue() : 0L);
        }
        if ((aggregation = this.getDocumentCounts(applicationIndexRequest, fromDate, toDate, "", TOTAL_WITHIN_SLA, "", 0)) != null) {
            valueCount = (ValueCount)aggregation.get(TOTAL_COUNT);
            applicationIndexResponse.setTotalWithinSLA(valueCount != null ? valueCount.getValue() : 0L);
        }
        if ((aggregation = this.getDocumentCounts(applicationIndexRequest, fromDate, toDate, "", OPEN_BEYOND_SLA, "", 0)) != null) {
            valueCount = (ValueCount)aggregation.get(TOTAL_COUNT);
            applicationIndexResponse.setOpenBeyondSLA(valueCount != null ? valueCount.getValue() : 0L);
        }
        if ((aggregation = this.getDocumentCounts(applicationIndexRequest, fromDate, toDate, "", CLOSED_BEYOND_SLA, "", 0)) != null) {
            valueCount = (ValueCount)aggregation.get(TOTAL_COUNT);
            applicationIndexResponse.setClosedBeyondSLA(valueCount != null ? valueCount.getValue() : 0L);
        }
        List<ServiceDetails> serviceDetails = this.getServiceDetails(applicationIndexRequest, fromDate, toDate);
        applicationIndexResponse.setServiceDetails(serviceDetails);
        return applicationIndexResponse;
    }

    private List<ServiceDetails> getServiceDetails(ApplicationIndexRequest applicationIndexRequest, Date fromDate, Date toDate) {
        ArrayList<ServiceDetails> serviceDetailsList = new ArrayList<ServiceDetails>();
        ValueCountBuilder countBuilder = (ValueCountBuilder)AggregationBuilders.count((String)TOTAL_COUNT).field(APPLICATION_NUMBER);
        BoolQueryBuilder boolQuery = this.prepareWhereClause(applicationIndexRequest, fromDate, toDate);
        TermsBuilder aggregation = ((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"by_service1").field(APPLICATION_TYPE)).size(5).subAggregation((AbstractAggregationBuilder)countBuilder)).order(Terms.Order.aggregation((String)TOTAL_COUNT, (boolean)false));
        NativeSearchQueryBuilder queryBuilder = new NativeSearchQueryBuilder().withIndices(new String[]{APPLICATIONS_INDEX}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)aggregation);
        NativeSearchQuery searchQueryColl = queryBuilder.build();
        Aggregations aggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, response -> response.getAggregations());
        LinkedHashMap<String, Long> aggregationResults = new LinkedHashMap<String, Long>();
        StringTerms serviceAggr = (StringTerms)aggr.get("by_service1");
        for (Terms.Bucket entry : serviceAggr.getBuckets()) {
            ValueCount valueCount = (ValueCount)entry.getAggregations().get(TOTAL_COUNT);
            aggregationResults.put(String.valueOf(entry.getKey()), valueCount.getValue());
        }
        for (Map.Entry entry : aggregationResults.entrySet()) {
            ServiceDetails serviceDetails = new ServiceDetails();
            serviceDetails.setServiceName((String)entry.getKey());
            serviceDetails.setBeyondSLA(aggregationResults.get(entry.getKey()) == null ? 0L : (Long)aggregationResults.get(entry.getKey()));
            serviceDetailsList.add(serviceDetails);
        }
        return serviceDetailsList;
    }

    private Map<String, Long> getDelayedDaysAggregate(ApplicationIndexRequest applicationIndexRequest, Date fromDate, Date toDate, String aggregationField, int size) {
        HashMap<String, Long> delayMap = new HashMap<String, Long>();
        BoolQueryBuilder boolQuery = this.prepareWhereClause(applicationIndexRequest, fromDate, toDate);
        boolQuery = boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)SLA_GAP).gt(0));
        AggregationBuilder aggregationBuilder = ((TermsBuilder)AggregationBuilders.terms((String)"by_service").field(aggregationField)).size(size).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)TOTAL_COUNT).field(SLA_GAP));
        NativeSearchQueryBuilder queryBuilder = new NativeSearchQueryBuilder().withIndices(new String[]{APPLICATIONS_INDEX}).withQuery((QueryBuilder)boolQuery);
        NativeSearchQuery searchQueryColl = queryBuilder.addAggregation((AbstractAggregationBuilder)aggregationBuilder).build();
        Aggregations aggregation = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, response -> response.getAggregations());
        StringTerms stringTerms = (StringTerms)aggregation.get("by_service");
        for (Terms.Bucket entry : stringTerms.getBuckets()) {
            Sum sumAggr = (Sum)entry.getAggregations().get(TOTAL_COUNT);
            delayMap.put(String.valueOf(entry.getKey()), (long)sumAggr.getValue());
        }
        return delayMap;
    }

    public List<ApplicationInfo> getApplicationInfo(ApplicationIndexRequest applicationIndexRequest) {
        ArrayList<ApplicationInfo> applications = new ArrayList<ApplicationInfo>();
        ArrayList<Map> appDetails = new ArrayList<Map>();
        Date fromDate = null;
        Date toDate = null;
        if (StringUtils.isNotBlank((CharSequence)applicationIndexRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)applicationIndexRequest.getToDate())) {
            fromDate = DateUtils.getDate(applicationIndexRequest.getFromDate(), DATE_FORMAT_YYYYMMDD);
            toDate = DateUtils.addDays((Date)DateUtils.getDate(applicationIndexRequest.getToDate(), DATE_FORMAT_YYYYMMDD), (int)1);
        }
        BoolQueryBuilder boolQuery = this.prepareWhereClause(applicationIndexRequest, fromDate, toDate);
        SearchResponse response = (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{APPLICATIONS_INDEX}).setQuery((QueryBuilder)boolQuery).execute().actionGet();
        int size = (int)response.getHits().totalHits();
        response = (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{APPLICATIONS_INDEX}).setQuery((QueryBuilder)boolQuery).setSize(size).addSort(APPLICATION_DATE, SortOrder.DESC).setFetchSource(new String[]{APPLICATION_DATE, APPLICATION_NUMBER, APPLICATION_TYPE, "applicantName", "applicantAddress", "status", CHANNEL, SLA, MODULE_NAME, SLA_GAP, CITY_NAME, OWNER_NAME}, null).execute().actionGet();
        for (SearchHit hit : response.getHits()) {
            appDetails.add(hit.sourceAsMap());
        }
        if (!appDetails.isEmpty()) {
            for (Map details : appDetails) {
                ApplicationInfo appInfo = new ApplicationInfo();
                appInfo.setAppDate(details.get(APPLICATION_DATE).toString().split("T")[0]);
                appInfo.setAppNo(details.get(APPLICATION_NUMBER).toString());
                appInfo.setService(details.get(APPLICATION_TYPE).toString());
                appInfo.setApplicantName(details.get("applicantName").toString());
                appInfo.setApplicantAddress(details.get("applicantAddress").toString());
                appInfo.setAppStatus(details.get("status").toString());
                appInfo.setSource(details.get(CHANNEL).toString());
                appInfo.setSla(details.get(SLA) == null ? 0 : (Integer)details.get(SLA));
                appInfo.setServiceGroup(details.get(MODULE_NAME).toString());
                appInfo.setAge(details.get(SLA_GAP) == null ? 0 : (Integer)details.get(SLA_GAP));
                appInfo.setPendingWith(details.get(OWNER_NAME).toString());
                appInfo.setUlbName(details.get(CITY_NAME).toString());
                applications.add(appInfo);
            }
        }
        return applications;
    }
}

