/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.service;

import java.util.List;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.repository.DepartmentRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class DepartmentService {
    private final DepartmentRepository departmentRepository;

    @Autowired
    public DepartmentService(DepartmentRepository departmentRepository) {
        this.departmentRepository = departmentRepository;
    }

    @Transactional
    public void createDepartment(Department department) {
        this.departmentRepository.save(department);
    }

    @Transactional
    public void updateDepartment(Department department) {
        this.departmentRepository.save(department);
    }

    public Department getDepartmentById(Long id) {
        return (Department)this.departmentRepository.findOne(id);
    }

    public Department getDepartmentByName(String name) {
        return this.departmentRepository.findByNameUpperCase(name.toUpperCase());
    }

    public List<Department> getAllDepartments() {
        return this.departmentRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public Department getDepartmentByCode(String code) {
        return this.departmentRepository.findByCode(code);
    }

    public List<Department> getAllDepartmentsByNameLike(String name) {
        return this.departmentRepository.findByNameContainingIgnoreCase(name);
    }

    @Transactional
    public void deleteDepartment(Department department) {
        this.departmentRepository.delete(department);
    }
}

