/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.entity;

import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.egov.infra.admin.master.entity.Action;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.persistence.entity.AbstractPersistable;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table(name="eg_feature")
@SequenceGenerator(name="SEQ_EG_FEATURE", sequenceName="SEQ_EG_FEATURE", allocationSize=1)
@Unique(fields={"name"}, enableDfltMsg=true)
public class Feature
extends AbstractPersistable<Long> {
    public static final String SEQ_FEATURE = "SEQ_EG_FEATURE";
    private static final long serialVersionUID = -5308237250026445794L;
    @Id
    @GeneratedValue(generator="SEQ_EG_FEATURE", strategy=GenerationType.SEQUENCE)
    private Long id;
    private String name;
    private String description;
    @ManyToOne
    @JoinColumn(name="module")
    private Module module;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(name="eg_feature_action", joinColumns={@JoinColumn(name="feature")}, inverseJoinColumns={@JoinColumn(name="action")})
    @Fetch(value=FetchMode.JOIN)
    private Set<Action> actions;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(name="eg_feature_role", joinColumns={@JoinColumn(name="feature")}, inverseJoinColumns={@JoinColumn(name="role")})
    @Fetch(value=FetchMode.JOIN)
    private Set<Role> roles;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    protected void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Module getModule() {
        return this.module;
    }

    public void setModule(Module module) {
        this.module = module;
    }

    public Set<Action> getActions() {
        return this.actions;
    }

    public void setActions(Set<Action> actions) {
        this.actions = actions;
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<Role> roles) {
        this.roles = roles;
    }

    public boolean hasRole(Role role) {
        return this.roles.contains(role);
    }

    public void addRole(Role role) {
        if (!this.hasRole(role)) {
            this.getRoles().add(role);
        }
    }

    public void removeRole(Role role) {
        if (this.hasRole(role)) {
            this.getRoles().remove(role);
        }
    }
}

