/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.entity;

import com.google.gson.annotations.Expose;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.egov.infra.admin.master.entity.HierarchyType;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="EG_BOUNDARY_TYPE")
@SequenceGenerator(name="SEQ_EG_BOUNDARY_TYPE", sequenceName="SEQ_EG_BOUNDARY_TYPE", allocationSize=1)
public class BoundaryType
extends AbstractAuditable {
    public static final String SEQ_BOUNDARY_TYPE = "SEQ_EG_BOUNDARY_TYPE";
    private static final long serialVersionUID = 859229842367886336L;
    @Expose
    @Id
    @GeneratedValue(generator="SEQ_EG_BOUNDARY_TYPE", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotBlank
    @SafeHtml
    private String name;
    @ManyToOne
    @NotNull
    @JoinColumn(name="hierarchytype")
    private HierarchyType hierarchyType;
    @ManyToOne
    @JoinColumn(name="parent")
    private BoundaryType parent;
    private Long hierarchy;
    @SafeHtml
    private String localName;
    @Transient
    private String parentName;
    @Transient
    private Set<BoundaryType> childBoundaryTypes;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public HierarchyType getHierarchyType() {
        return this.hierarchyType;
    }

    public void setHierarchyType(HierarchyType hierarchyType) {
        this.hierarchyType = hierarchyType;
    }

    public BoundaryType getParent() {
        return this.parent;
    }

    public void setParent(BoundaryType parent) {
        this.parent = parent;
    }

    public Long getHierarchy() {
        return this.hierarchy;
    }

    public void setHierarchy(Long hierarchy) {
        this.hierarchy = hierarchy;
    }

    public String getParentName() {
        return this.parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public Set<BoundaryType> getChildBoundaryTypes() {
        return this.childBoundaryTypes;
    }

    public void setChildBoundaryTypes(Set<BoundaryType> childBoundaryTypes) {
        this.childBoundaryTypes = childBoundaryTypes;
    }

    public void addChildBoundaryType(BoundaryType boundaryType) {
        boundaryType.setParent(this);
        this.childBoundaryTypes.add(boundaryType);
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BoundaryType other = (BoundaryType)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

