/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.entity;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table(name="eg_action")
@SequenceGenerator(name="SEQ_EG_ACTION", sequenceName="SEQ_EG_ACTION", allocationSize=1)
@Cacheable
public class Action
extends AbstractAuditable {
    public static final String SEQ_ACTION = "SEQ_EG_ACTION";
    private static final long serialVersionUID = -5459067787684736822L;
    @Id
    @GeneratedValue(generator="SEQ_EG_ACTION", strategy=GenerationType.SEQUENCE)
    private Long id;
    @Column(unique=true)
    private String name;
    private String url;
    private String queryParams;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinTable(name="eg_roleaction", joinColumns={@JoinColumn(name="actionid")}, inverseJoinColumns={@JoinColumn(name="roleid")})
    @Fetch(value=FetchMode.SUBSELECT)
    private Set<Role> roles = new HashSet<Role>();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="parentModule")
    private Module parentModule;
    private Integer orderNumber;
    private String displayName;
    private boolean enabled;
    private String contextRoot;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getQueryParams() {
        return this.queryParams;
    }

    public void setQueryParams(String queryParams) {
        this.queryParams = queryParams;
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<Role> roles) {
        this.roles = roles;
    }

    public Module getParentModule() {
        return this.parentModule;
    }

    public void setParentModule(Module parentModule) {
        this.parentModule = parentModule;
    }

    public Integer getOrderNumber() {
        return this.orderNumber;
    }

    public void setOrderNumber(Integer orderNumber) {
        this.orderNumber = orderNumber;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    public void addRole(Role role) {
        if (!this.hasRole(role)) {
            this.getRoles().add(role);
        }
    }

    public void removeRole(Role role) {
        if (this.hasRole(role)) {
            this.getRoles().remove(role);
        }
    }

    public boolean hasRole(Role role) {
        return this.getRoles().contains(role);
    }
}

