/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infstr.security.spring.filter;

import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.security.audit.entity.SystemAudit;
import org.egov.infra.security.audit.service.SystemAuditService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.stereotype.Component;

@Component
public class CustomLogoutHandler
implements LogoutHandler {
    @Autowired
    private SystemAuditService systemAuditService;

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        this.clearAllCookies(request, response);
        this.auditLogout(authentication);
    }

    private void clearAllCookies(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length < 1) {
            return;
        }
        for (Cookie cookie : cookies) {
            cookie.setMaxAge(0);
            cookie.setPath("/");
            cookie.setValue(null);
            response.addCookie(cookie);
        }
    }

    private void auditLogout(Authentication authentication) {
        String systemAuditId;
        if (authentication != null && StringUtils.isNotBlank((CharSequence)(systemAuditId = (String)((HashMap)authentication.getCredentials()).get("loginLogId")))) {
            SystemAudit systemAudit = this.systemAuditService.getSystemAuditById(Long.valueOf(systemAuditId));
            systemAudit.setLogoutTime(new Date());
            this.systemAuditService.createOrUpdateSystemAudit(systemAudit);
        }
    }
}

