/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infstr.search;

import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infstr.search.SearchQuery;
import org.egov.infstr.services.Page;
import org.egov.infstr.services.PersistenceService;
import org.hibernate.Criteria;
import org.hibernate.criterion.Projections;

public class SearchQueryCriteria
implements SearchQuery {
    private final Criteria searchCriteria;
    private final Criteria countCriteria;

    public SearchQueryCriteria(Criteria searchCriteria, Criteria countCriteria) {
        if (searchCriteria == countCriteria) {
            throw new ApplicationRuntimeException("Search Criteria cannot be same as Count Criteria. Please pass different objects!");
        }
        this.searchCriteria = searchCriteria;
        this.countCriteria = countCriteria;
        this.countCriteria.setProjection(Projections.rowCount());
    }

    @Override
    public int getCount(PersistenceService persistenceService) {
        return (Integer)this.countCriteria.uniqueResult();
    }

    @Override
    public Page getPage(PersistenceService persistenceService, int pageNum, int pageSize) {
        return new Page(this.searchCriteria, (Integer)pageNum, (Integer)pageSize);
    }
}

