/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.utils;

import java.util.List;
import org.displaytag.pagination.PaginatedList;
import org.displaytag.properties.SortOrderEnum;
import org.egov.infstr.services.Page;

public class EgovPaginatedList
implements PaginatedList {
    private int fullListSize;
    private int pageNumber;
    private List list;
    private int objectsPerPage;
    private String sortCriterion;
    private SortOrderEnum sortDirection = SortOrderEnum.ASCENDING;

    public EgovPaginatedList(Page page, int fullListSize) {
        this(page, fullListSize, null, SortOrderEnum.ASCENDING);
    }

    public EgovPaginatedList(Page page, int fullListSize, String sortCriterion, SortOrderEnum sortDir) {
        this.pageNumber = page.getPageNo();
        this.objectsPerPage = page.getPageSize();
        this.fullListSize = fullListSize;
        this.list = page.getList();
        this.sortCriterion = sortCriterion;
        this.sortDirection = sortDir;
    }

    public EgovPaginatedList(int pageNumber, int objectsPerPage) {
        this.pageNumber = pageNumber < 0 ? 0 : pageNumber;
        this.objectsPerPage = objectsPerPage;
    }

    public EgovPaginatedList(Page page, String sortCriterion, SortOrderEnum sortDir) {
        this.pageNumber = page.getPageNo();
        this.objectsPerPage = page.getPageSize();
        this.sortCriterion = sortCriterion;
        this.sortDirection = sortDir;
    }

    public EgovPaginatedList(int pageNumber, int objectsPerPage, String sortCriterion, SortOrderEnum sortDir) {
        this.pageNumber = pageNumber < 0 ? 0 : pageNumber;
        this.objectsPerPage = objectsPerPage;
        this.sortCriterion = sortCriterion;
        this.sortDirection = sortDir;
    }

    public int getFullListSize() {
        return this.fullListSize;
    }

    public void setFullListSize(int fullListSize) {
        this.fullListSize = fullListSize;
    }

    public List getList() {
        return this.list;
    }

    public void setList(List list) {
        this.list = list;
    }

    public int getObjectsPerPage() {
        return this.objectsPerPage;
    }

    public void setObjectsPerPage(int objectsPerPage) {
        this.objectsPerPage = objectsPerPage;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber < 0 ? 0 : pageNumber;
    }

    public String getSearchId() {
        return null;
    }

    public String getSortCriterion() {
        return this.sortCriterion;
    }

    public void setSortCriterion(String sortCriterion) {
        this.sortCriterion = sortCriterion;
    }

    public SortOrderEnum getSortDirection() {
        return this.sortDirection;
    }

    public void setSortDirection(SortOrderEnum sortDirection) {
        this.sortDirection = sortDirection;
    }
}

