/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.support.json.adapter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import org.egov.infra.admin.master.entity.Boundary;

public class BoundaryAdapter
implements JsonSerializer<Boundary> {
    public JsonElement serialize(Boundary boundary, Type type, JsonSerializationContext jsc) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("dd-MM-yyyy");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", boundary.getName());
        jsonObject.addProperty("boundaryNameLocal", boundary.getLocalName());
        jsonObject.addProperty("boundaryNum", (Number)boundary.getBoundaryNum());
        jsonObject.addProperty("fromDate", dateFormatter.format(boundary.getFromDate()));
        jsonObject.addProperty("boundaryParentName", boundary.getParent() != null ? boundary.getParent().getName() : "");
        if (boundary.getToDate() == null) {
            jsonObject.addProperty("toDate", "NA");
        } else {
            jsonObject.addProperty("toDate", dateFormatter.format(boundary.getToDate()));
        }
        return jsonObject;
    }
}

