/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.struts.actions.workflow;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.workflow.entity.WorkflowTypes;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrixDetails;
import org.egov.infra.workflow.matrix.service.WorkFlowMatrixService;
import org.egov.pims.commons.Designation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParentPackage(value="egov")
public class WorkFlowMatrixAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    public WorkFlowMatrix workFlowMatrix = new WorkFlowMatrix();
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkFlowMatrixAction.class);
    private String mode;
    private Boolean amountRule;
    private Date fromDate;
    private Date toDate;
    private BigDecimal fromAmount;
    private BigDecimal toAmount;
    private String additionalRule;
    private Long objectType;
    private String[] department;
    private String[] departmentSelected;
    private String additionalRuleSelected;
    private List<Department> departmentList = new ArrayList<Department>();
    private List<WorkflowTypes> objectList = new ArrayList<WorkflowTypes>();
    private List<String> additionlRuleList = new ArrayList<String>();
    private WorkFlowMatrixService workFlowMatrixService;
    private Long objectTypeid;
    private List additionalRuleList;
    private List<WorkFlowMatrixDetails> workFlowMatrixDetails = new ArrayList<WorkFlowMatrixDetails>();
    private List<WorkFlowMatrixDetails> workFlowMatrixRejectDetails = new ArrayList<WorkFlowMatrixDetails>();
    private List<Designation> designationList = new ArrayList<Designation>();
    private List stateList = new ArrayList();
    private List statusList = new ArrayList();
    private List buttonList = new ArrayList();
    private List actionList = new ArrayList();
    private List<WorkFlowMatrixDetails> viewList = new ArrayList<WorkFlowMatrixDetails>();
    private String objectTypeView;
    private Date fromDateView;
    private Date toDateView;
    private BigDecimal fromQtyView;
    private BigDecimal toQtyView;
    private String additionalRuleView;
    private String searchAction;
    private Date modifyToDate;
    private Date legacyDate;
    private final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
    private String departmentstring;
    private WorkFlowMatrixDetails rejectionDetail;
    public static final String REJECTED = "Rejected";
    public static final String DEFAULT = "ANY";
    public static final String SEARCH = "search";
    public static final String RESULTS = "results";
    public static final String VIEW = "view";
    public static final String MODIFY = "modify";
    public static final String OBJECTTYPE = "ObjectType";
    public static final String ADDITIONALRULE = "AdditionalRule";
    public static final String FROMDATE = "FromDate";
    public static final String TODATE = "ToDate";
    public static final String FROMAMOUNT = "FromAmount";
    public static final String TOAMOUNT = "ToAmount";
    public static final String DEPARTMENTS = "Departments";
    public static final String MODIFYDATE = "ModifyDate";

    @Override
    public void prepare() {
        LOGGER.info("Prepare Method is called");
        super.prepare();
        Department anyDept = new Department();
        anyDept.setName(DEFAULT);
        anyDept.setCode(DEFAULT);
        this.departmentList = this.workFlowMatrixService.getdepartmentList();
        this.departmentList.add(anyDept);
        this.objectList = this.workFlowMatrixService.getobjectTypeList();
        this.addDropdownData("objectTypeList", this.objectList);
        this.addDropdownData("departmentList", this.departmentList);
        if (this.getObjectType() != null) {
            this.additionlRuleList = this.workFlowMatrixService.getAdditionalRulesforObject(this.getObjectType());
            this.stateList = this.workFlowMatrixService.getDetailsforObject(this.getObjectType()).get("StateList");
            this.statusList = this.workFlowMatrixService.getDetailsforObject(this.getObjectType()).get("StatusList");
            this.buttonList = this.workFlowMatrixService.getDetailsforObject(this.getObjectType()).get("ButtonsList");
            this.actionList = this.workFlowMatrixService.getDetailsforObject(this.getObjectType()).get("ActionsList");
        }
        this.designationList = this.workFlowMatrixService.getdesignationList();
        this.addDropdownData("additionalRuleList", this.additionlRuleList);
        this.addDropdownData("stateList", this.stateList);
        this.addDropdownData("statusList", this.statusList);
        this.addDropdownData("buttonList", this.buttonList);
        this.addDropdownData("designationList", this.designationList);
        this.addDropdownData("actionList", this.actionList);
        LOGGER.info("Prepare Method Ended");
    }

    public Object getModel() {
        return null;
    }

    public String newForm() {
        this.setAmountRule(Boolean.FALSE);
        return "new";
    }

    public String viewForm() {
        this.setMode(SEARCH);
        return SEARCH;
    }

    public String viewMatrixResults() {
        LOGGER.info("viewMatrixResults Method is called");
        HashMap workflowheaderparams = this.getHeaderParams();
        this.getWorkFlowMatrixObject(workflowheaderparams);
        this.setMode(RESULTS);
        LOGGER.info("viewMatrixResults Method is ended");
        return SEARCH;
    }

    public String buildWorkflow() {
        LOGGER.info("buildWorkflow Method is called");
        this.setDepartmentSelected(this.getDepartment());
        this.setAdditionalRuleSelected(this.getAdditionalRule());
        if (!this.checkEistingMatrix()) {
            this.addActionError("WorkFlow already exists for " + this.getDepartmentstring() + " departments");
            return "new";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyyy");
        Date formatfromDate = null;
        Date formatCurrentDate = null;
        try {
            formatCurrentDate = dateFormat.parse(dateFormat.format(new Date()));
            formatfromDate = dateFormat.parse(dateFormat.format(this.getFromDate()));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (formatfromDate.before(formatCurrentDate) && this.getDepartment().length > 1) {
            this.addActionError("Only one department can be selected if you are entering matrix for older dates ");
            return "new";
        }
        if (formatfromDate.before(formatCurrentDate) && !this.checkExistingMatrixforLegacy()) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.getLegacyDate());
            calendar.add(6, -1);
            this.addActionMessage("A workflow is already present from " + this.sdf.format(this.getLegacyDate()) + ". The workflow you are about to add will be valid for records created between " + this.sdf.format(this.getFromDate()) + " and " + this.sdf.format(calendar.getTime()));
        }
        this.setMode("edit");
        this.workFlowMatrixDetails.add(new WorkFlowMatrixDetails());
        this.workFlowMatrixRejectDetails.add(new WorkFlowMatrixDetails());
        LOGGER.info("buildWorkflow Method is ended");
        return "new";
    }

    private void deleteWorkFlowMatrixObject(HashMap workflowsearchparams) {
        this.workFlowMatrixService.deleteWorkFlowforObject(workflowsearchparams);
    }

    private boolean checkEistingMatrix() {
        LOGGER.info("checkEistingMatrix Method is called");
        HashMap workflowheaderparams = this.getHeaderParams();
        List checkmatrixList = this.workFlowMatrixService.checkIfMatrixExists(workflowheaderparams);
        if (checkmatrixList == null) {
            return true;
        }
        StringBuffer departmentString = new StringBuffer();
        for (Long matrixid : checkmatrixList) {
            if (new String(departmentString).contains(this.workFlowMatrixService.getWorkFlowObjectbyId(matrixid).getDepartment())) continue;
            departmentString.append(" ");
            departmentString.append(this.workFlowMatrixService.getWorkFlowObjectbyId(matrixid).getDepartment());
            departmentString.append(",");
        }
        this.setDepartmentstring(departmentString.substring(0, departmentString.length() - 1));
        LOGGER.info("checkEistingMatrix Method is ended");
        return false;
    }

    private boolean checkExistingMatrixforLegacy() {
        LOGGER.info("checkExistingMatrixforLegacy Method is called");
        HashMap workflowheaderparams = this.getHeaderParams();
        this.setLegacyDate(this.workFlowMatrixService.checkLegacyMatrix(workflowheaderparams));
        LOGGER.info("checkExistingMatrixforLegacy Method is ended");
        return this.legacyDate == null;
    }

    public String getAdditionalRuleforObjecttype() {
        this.additionalRuleList = this.workFlowMatrixService.getAdditionalRulesforObject(this.getObjectTypeid());
        return "additionalRule";
    }

    public String createWorkFlowforobjects() {
        LOGGER.info("createWorkFlowforobjects Method is called");
        List<WorkFlowMatrixDetails> matrixList = this.getWorkFlowMatrixDetails();
        Collections.sort(matrixList);
        this.prepareWorkFlowMatrixDetails(matrixList);
        this.setDepartmentSelected(this.getDepartment());
        this.setAdditionalRuleSelected(this.getAdditionalRule());
        this.setMode(VIEW);
        LOGGER.info("createWorkFlowforobjects Method is ended");
        return "new";
    }

    /*
     * Enabled aggressive block sorting
     */
    private String prepareWorkFlowMatrixDetails(List<WorkFlowMatrixDetails> matrixList) {
        LOGGER.info("prepareWorkFlowMatrixDetails Method is called");
        LinkedList<WorkFlowMatrix> actWorkFlowMatrixList = new LinkedList<WorkFlowMatrix>();
        for (int i = 0; i < matrixList.size(); ++i) {
            WorkFlowMatrix wfMatrixObj = new WorkFlowMatrix();
            wfMatrixObj.setFromDate(this.getFromDate());
            if (this.getLegacyDate() != null) {
                this.setToDate(this.getLegacyDate());
            }
            wfMatrixObj.setToDate(this.getToDate());
            wfMatrixObj.setObjectType(this.workFlowMatrixService.getobjectTypebyId(this.getObjectType()).getType());
            wfMatrixObj.setFromQty(this.getFromAmount());
            wfMatrixObj.setToQty(this.getToAmount());
            wfMatrixObj.setAdditionalRule(this.getAdditionalRule() != "-1" ? this.getAdditionalRule() : null);
            actWorkFlowMatrixList.add(wfMatrixObj);
        }
        if (this.getMode().equals(MODIFY)) {
            if (!this.updateExistingMatrix().booleanValue()) {
                this.deleteWorkFlowMatrixObject(this.getSearchParams());
                this.workFlowMatrixService.save(this.createActualWorkFlowMatrixDetails(actWorkFlowMatrixList, matrixList), this.getDepartment());
                return "new";
            }
            this.workFlowMatrixService.save(this.createActualWorkFlowMatrixDetails(actWorkFlowMatrixList, matrixList), this.getDepartment());
        } else {
            this.workFlowMatrixService.save(this.createActualWorkFlowMatrixDetails(actWorkFlowMatrixList, matrixList), this.getDepartment());
        }
        LOGGER.info("prepareWorkFlowMatrixDetails Method is ended");
        return "new";
    }

    private List<WorkFlowMatrix> createActualWorkFlowMatrixDetails(List<WorkFlowMatrix> ActualwfMatrixObjList, List<WorkFlowMatrixDetails> matrixList) {
        LOGGER.info("createActualWorkFlowMatrixDetails Method is called");
        for (int i = 0; i < ActualwfMatrixObjList.size(); ++i) {
            WorkFlowMatrix wfMatrixObj = ActualwfMatrixObjList.get(i);
            wfMatrixObj.setNextState(matrixList.get(i).getState());
            wfMatrixObj.setNextAction(matrixList.get(i).getAction());
            wfMatrixObj.setNextDesignation(matrixList.get(i).getDesignationString());
            wfMatrixObj.setNextStatus(matrixList.get(i).getStatus());
            wfMatrixObj.setValidActions(matrixList.get(i).getButtonString());
            wfMatrixObj.setAdditionalRule(!this.getAdditionalRule().equals("-1") ? this.getAdditionalRule() : null);
            if (i == 0) {
                wfMatrixObj.setCurrentState("NEW");
                wfMatrixObj.setCurrentStatus(matrixList.get(i).getStatus());
                continue;
            }
            wfMatrixObj.setCurrentState(ActualwfMatrixObjList.get(i - 1).getNextState());
            wfMatrixObj.setCurrentStatus(ActualwfMatrixObjList.get(i - 1).getNextStatus());
            wfMatrixObj.setPendingActions(ActualwfMatrixObjList.get(i - 1).getNextAction());
            wfMatrixObj.setCurrentDesignation(ActualwfMatrixObjList.get(i - 1).getNextDesignation());
        }
        if (ActualwfMatrixObjList.size() > 1) {
            if (this.getWorkFlowMatrixRejectDetails().get(0).getRejectAction() == null) {
                WorkFlowMatrix matrixforReject = ActualwfMatrixObjList.get(0).clone();
                matrixforReject.setCurrentState(REJECTED);
                ActualwfMatrixObjList.add(matrixforReject);
            } else {
                ArrayList<WorkFlowMatrix> RejectionList = new ArrayList<WorkFlowMatrix>();
                List<WorkFlowMatrixDetails> matrixDetList = this.getWorkFlowMatrixRejectDetails();
                if (matrixDetList.size() > 0) {
                    for (int i = 0; i < matrixDetList.size(); ++i) {
                        WorkFlowMatrix wfMatrixObj = new WorkFlowMatrix();
                        wfMatrixObj.setFromDate(this.getFromDate());
                        if (this.getLegacyDate() != null) {
                            this.setToDate(this.getLegacyDate());
                        }
                        wfMatrixObj.setToDate(this.getToDate());
                        wfMatrixObj.setObjectType(this.workFlowMatrixService.getobjectTypebyId(this.getObjectType()).getType());
                        wfMatrixObj.setFromQty(this.getFromAmount());
                        wfMatrixObj.setToQty(this.getToAmount());
                        wfMatrixObj.setAdditionalRule(!this.getAdditionalRule().equals("-1") ? this.getAdditionalRule() : null);
                        if (i == 0) {
                            wfMatrixObj.setCurrentState(REJECTED);
                        } else {
                            wfMatrixObj.setCurrentState(((WorkFlowMatrix)RejectionList.get(i - 1)).getNextState());
                            wfMatrixObj.setCurrentStatus(((WorkFlowMatrix)RejectionList.get(i - 1)).getNextStatus());
                            wfMatrixObj.setPendingActions(((WorkFlowMatrix)RejectionList.get(i - 1)).getNextAction());
                            wfMatrixObj.setCurrentDesignation(((WorkFlowMatrix)RejectionList.get(i - 1)).getNextDesignation());
                        }
                        wfMatrixObj.setNextDesignation(matrixDetList.get(i).getRejectdesignationString());
                        wfMatrixObj.setNextAction(matrixDetList.get(i).getRejectAction());
                        wfMatrixObj.setNextState(matrixDetList.get(i).getRejectState());
                        wfMatrixObj.setNextStatus(matrixDetList.get(i).getRejectStatus());
                        wfMatrixObj.setValidActions(matrixDetList.get(i).getRejectbuttonString());
                        RejectionList.add(wfMatrixObj);
                    }
                }
                ActualwfMatrixObjList.addAll(RejectionList);
            }
        }
        LOGGER.info("createActualWorkFlowMatrixDetails Method is ended");
        return ActualwfMatrixObjList;
    }

    private List<WorkFlowMatrixDetails> getWorkFlowMatrixObject(HashMap<String, String> workFlowObjectMap) {
        this.viewList = this.workFlowMatrixService.getWorkFlowMatrixObjectForView(workFlowObjectMap);
        return this.viewList;
    }

    public String prepareModifyForm() {
        LOGGER.info("prepareModifyForm Method is called");
        HashMap workflowsearchparams = this.getSearchParams();
        this.setDepartmentSelected(this.getDepartment());
        this.setAdditionalRuleSelected((String)workflowsearchparams.get(ADDITIONALRULE));
        if (workflowsearchparams.get(FROMAMOUNT) != null) {
            this.setFromAmount((BigDecimal)workflowsearchparams.get(FROMAMOUNT));
            this.setToAmount((BigDecimal)workflowsearchparams.get(TOAMOUNT));
            this.setAmountRule(Boolean.TRUE);
        } else {
            this.setAmountRule(Boolean.FALSE);
        }
        List matrixList = this.workFlowMatrixService.getWorkFlowforObjectforModify(workflowsearchparams);
        int sublistIndex = matrixList.size();
        for (int i = 0; i < matrixList.size(); ++i) {
            if (!((WorkFlowMatrix)matrixList.get(i)).getNextAction().equals("END")) continue;
            sublistIndex = i;
        }
        List<WorkFlowMatrixDetails> workFlowList = new LinkedList<WorkFlowMatrixDetails>();
        List<WorkFlowMatrixDetails> rejectionList = new LinkedList<WorkFlowMatrixDetails>();
        workFlowList = this.workFlowMatrixService.prepareWorkFlowMatrixDetailsList(matrixList.subList(0, sublistIndex + 1), workFlowList, Boolean.TRUE);
        rejectionList = this.workFlowMatrixService.prepareWorkFlowMatrixDetailsList(matrixList.subList(sublistIndex + 1, matrixList.size()), rejectionList, Boolean.FALSE);
        if (rejectionList.isEmpty()) {
            rejectionList.add(new WorkFlowMatrixDetails());
        }
        this.workFlowMatrixDetails.addAll(workFlowList);
        this.setMode(MODIFY);
        this.setModifyToDate(new Date());
        this.setFromDate(new Date());
        this.workFlowMatrixRejectDetails.addAll(rejectionList);
        LOGGER.info("prepareModifyForm Method is ended");
        return "new";
    }

    public String deleteWorkFlowMatrix() {
        LOGGER.info("deleteWorkFlowMatrix Method is called");
        HashMap workflowsearchparams = this.getSearchParams();
        this.deleteWorkFlowMatrixObject(workflowsearchparams);
        HashMap workflowheaderparams = this.getHeaderParams();
        this.getWorkFlowMatrixObject(workflowheaderparams);
        this.setMode(RESULTS);
        this.addActionMessage("The Matrix was successfully deleted");
        LOGGER.info("deleteWorkFlowMatrix Method is ended");
        return SEARCH;
    }

    private Boolean updateExistingMatrix() {
        HashMap workflowheaderparams = this.getSearchParams();
        return this.workFlowMatrixService.updateWorkFlowforObject(workflowheaderparams);
    }

    private HashMap getHeaderParams() {
        LOGGER.info("getHeaderParams Method is called");
        HashMap<String, Object> workflowheaderparams = new HashMap<String, Object>();
        workflowheaderparams.put(OBJECTTYPE, this.getObjectType());
        workflowheaderparams.put(ADDITIONALRULE, this.getAdditionalRule());
        workflowheaderparams.put(FROMDATE, this.getFromDate());
        workflowheaderparams.put(TODATE, this.getToDate());
        workflowheaderparams.put(FROMAMOUNT, this.getFromAmount());
        workflowheaderparams.put(TOAMOUNT, this.getToAmount());
        workflowheaderparams.put(DEPARTMENTS, this.getDepartment());
        workflowheaderparams.put(MODIFYDATE, this.getModifyToDate());
        LOGGER.info("getHeaderParams Method is ended");
        return workflowheaderparams;
    }

    private HashMap getSearchParams() {
        LOGGER.info("getSearchParams Method is called");
        HashMap<String, Object> workflowsearchparams = new HashMap<String, Object>();
        workflowsearchparams.put(OBJECTTYPE, this.getObjectTypeView());
        workflowsearchparams.put(ADDITIONALRULE, this.getAdditionalRuleView());
        workflowsearchparams.put(FROMDATE, this.getFromDateView());
        workflowsearchparams.put(TODATE, this.getToDateView());
        workflowsearchparams.put(FROMAMOUNT, this.getFromQtyView());
        workflowsearchparams.put(TOAMOUNT, this.getToQtyView());
        workflowsearchparams.put(DEPARTMENTS, this.getDepartment());
        workflowsearchparams.put(MODIFYDATE, this.getModifyToDate());
        LOGGER.info("getSearchParams Method is ended");
        return workflowsearchparams;
    }

    public String getSearchAction() {
        return this.searchAction;
    }

    public void setSearchAction(String searchAction) {
        this.searchAction = searchAction;
    }

    public String getObjectTypeView() {
        return this.objectTypeView;
    }

    public void setObjectTypeView(String objectTypeView) {
        this.objectTypeView = objectTypeView;
    }

    public Date getFromDateView() {
        return this.fromDateView;
    }

    public void setFromDateView(Date fromDateView) {
        this.fromDateView = fromDateView;
    }

    public Date getToDateView() {
        return this.toDateView;
    }

    public void setToDateView(Date toDateView) {
        this.toDateView = toDateView;
    }

    public String getAdditionalRuleView() {
        return this.additionalRuleView;
    }

    public void setAdditionalRuleView(String additionalRuleView) {
        this.additionalRuleView = additionalRuleView;
    }

    public List<WorkFlowMatrixDetails> getViewList() {
        return this.viewList;
    }

    public void setViewList(List<WorkFlowMatrixDetails> viewList) {
        this.viewList = viewList;
    }

    public List getButtonList() {
        return this.buttonList;
    }

    public void setButtonList(List buttonList) {
        this.buttonList = buttonList;
    }

    public List getStatusList() {
        return this.statusList;
    }

    public void setStatusList(List statusList) {
        this.statusList = statusList;
    }

    public List getStateList() {
        return this.stateList;
    }

    public void setStateList(List stateList) {
        this.stateList = stateList;
    }

    public List<Designation> getDesignationList() {
        return this.designationList;
    }

    public void setDesignationList(List<Designation> designationList) {
        this.designationList = designationList;
    }

    public List<WorkFlowMatrixDetails> getWorkFlowMatrixDetails() {
        return this.workFlowMatrixDetails;
    }

    public void setWorkFlowMatrixDetails(List<WorkFlowMatrixDetails> workFlowMatrixDetails) {
        this.workFlowMatrixDetails = workFlowMatrixDetails;
    }

    public List getAdditionalRuleList() {
        return this.additionalRuleList;
    }

    public void setAdditionalRuleList(List additionalRuleList) {
        this.additionalRuleList = additionalRuleList;
    }

    public Long getObjectTypeid() {
        return this.objectTypeid;
    }

    public void setObjectTypeid(Long objectTypeid) {
        this.objectTypeid = objectTypeid;
    }

    public String[] getDepartmentSelected() {
        return this.departmentSelected;
    }

    public void setDepartmentSelected(String[] departmentSelected) {
        this.departmentSelected = departmentSelected;
    }

    public String getAdditionalRuleSelected() {
        return this.additionalRuleSelected;
    }

    public void setAdditionalRuleSelected(String additionalRuleSelected) {
        this.additionalRuleSelected = additionalRuleSelected;
    }

    public WorkFlowMatrixService getWorkFlowMatrixService() {
        return this.workFlowMatrixService;
    }

    public void setWorkFlowMatrixService(WorkFlowMatrixService workFlowMatrixService) {
        this.workFlowMatrixService = workFlowMatrixService;
    }

    public String[] getDepartment() {
        return this.department;
    }

    public void setDepartment(String[] department) {
        this.department = department;
    }

    public String getAdditionalRule() {
        return this.additionalRule;
    }

    public void setAdditionalRule(String additionalRule) {
        this.additionalRule = additionalRule;
    }

    public Long getObjectType() {
        return this.objectType;
    }

    public void setObjectType(Long objectType) {
        this.objectType = objectType;
    }

    public Boolean getAmountRule() {
        return this.amountRule;
    }

    public void setAmountRule(Boolean amountRule) {
        this.amountRule = amountRule;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public BigDecimal getFromAmount() {
        return this.fromAmount;
    }

    public void setFromAmount(BigDecimal fromAmount) {
        this.fromAmount = fromAmount;
    }

    public BigDecimal getToAmount() {
        return this.toAmount;
    }

    public void setToAmount(BigDecimal toAmount) {
        this.toAmount = toAmount;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public WorkFlowMatrix getWorkFlowMatrix() {
        return this.workFlowMatrix;
    }

    public void setWorkFlowMatrix(WorkFlowMatrix workFlowMatrix) {
        this.workFlowMatrix = workFlowMatrix;
    }

    public BigDecimal getFromQtyView() {
        return this.fromQtyView;
    }

    public void setFromQtyView(BigDecimal fromQtyView) {
        this.fromQtyView = fromQtyView;
    }

    public BigDecimal getToQtyView() {
        return this.toQtyView;
    }

    public void setToQtyView(BigDecimal toQtyView) {
        this.toQtyView = toQtyView;
    }

    public Date getModifyToDate() {
        return this.modifyToDate;
    }

    public void setModifyToDate(Date modifyToDate) {
        this.modifyToDate = modifyToDate;
    }

    public Date getLegacyDate() {
        return this.legacyDate;
    }

    public void setLegacyDate(Date legacyDate) {
        this.legacyDate = legacyDate;
    }

    public WorkFlowMatrixDetails getRejectionDetail() {
        return this.rejectionDetail;
    }

    public void setRejectionDetail(WorkFlowMatrixDetails rejectionDetail) {
        this.rejectionDetail = rejectionDetail;
    }

    public String getDepartmentstring() {
        return this.departmentstring;
    }

    public void setDepartmentstring(String departmentstring) {
        this.departmentstring = departmentstring;
    }

    public List<WorkFlowMatrixDetails> getWorkFlowMatrixRejectDetails() {
        return this.workFlowMatrixRejectDetails;
    }

    public void setWorkFlowMatrixRejectDetails(List<WorkFlowMatrixDetails> workFlowMatrixRejectDetails) {
        this.workFlowMatrixRejectDetails = workFlowMatrixRejectDetails;
    }
}

