/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.struts.actions;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionSupport;
import com.opensymphony.xwork2.ModelDriven;
import com.opensymphony.xwork2.Preparable;
import com.opensymphony.xwork2.interceptor.ParameterNameAware;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.interceptor.ParameterAware;
import org.apache.struts2.interceptor.RequestAware;
import org.apache.struts2.interceptor.SessionAware;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infstr.services.PersistenceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ParentPackage(value="egov")
public abstract class BaseFormAction
extends ActionSupport
implements ModelDriven<Object>,
ParameterAware,
SessionAware,
Preparable,
RequestAware,
ParameterNameAware {
    public static final String INDEX = "index";
    public static final String NEW = "new";
    public static final String EDIT = "edit";
    public static final String VIEW = "view";
    private static final long serialVersionUID = 1L;
    @Autowired
    @Qualifier(value="persistenceService")
    protected transient PersistenceService persistenceService;
    protected transient Map<String, Object> request;
    protected transient Map<String, List> dropdownData = new HashMap<String, List>();
    protected transient Map<String, Class> relations = new HashMap<String, Class>();
    protected transient Map<String, String> ordering = new HashMap<String, String>();
    protected transient Map<String, String[]> parameters;
    private transient Map<String, Object> session;

    protected Map<String, Object> session() {
        return this.session;
    }

    public Map<String, Object> getSession() {
        return this.session;
    }

    public void setSession(Map<String, Object> session) {
        this.session = session;
    }

    public PersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    public void setPersistenceService(PersistenceService service) {
        this.persistenceService = service;
    }

    public void prepare() {
        Map<String, Class> relationships = this.getRelationships();
        for (Map.Entry<String, Class> rel : relationships.entrySet()) {
            try {
                this.setRelationship(rel.getKey(), rel.getValue());
            }
            catch (IntrospectionException e) {
                throw new ApplicationRuntimeException(String.format("Could not set relationship for key %s of class %s", rel.getKey(), rel.getValue().getSimpleName()), e);
            }
        }
    }

    private void setRelationship(String relationshipName, Class class1) throws IntrospectionException {
        String id;
        String[] ids = this.parameters.get(relationshipName);
        if (ids != null && ids.length > 0 && StringUtils.isNotBlank((CharSequence)(id = ids[0])) && Long.valueOf(id) > 0L) {
            PropertyDescriptor propDiscriptor = new PropertyDescriptor("id", class1);
            if (class1 != null && "Fund".equals(class1.getSimpleName())) {
                this.setValue(relationshipName, this.getPersistenceService().load(Integer.valueOf(id), class1));
            } else if (propDiscriptor.getPropertyType().isAssignableFrom(Long.class)) {
                this.setValue(relationshipName, this.getPersistenceService().getSession().get(class1, (Serializable)Long.valueOf(id)));
            } else {
                this.setValue(relationshipName, this.getPersistenceService().load(Integer.valueOf(id), class1));
            }
        }
    }

    protected void setValue(String relationshipName, Object relation) {
        ActionContext.getContext().getValueStack().setValue("model." + relationshipName, relation);
    }

    public Map<String, Class> getRelationships() {
        return this.relations;
    }

    public Map<String, List> getDropdownData() {
        return this.dropdownData;
    }

    public void setRequest(Map<String, Object> request) {
        this.request = request;
    }

    protected void setupDropdownDataExcluding(String ... excluded) {
        ArrayList<Object> excludedRelations = new ArrayList<Object>();
        if (excluded != null) {
            for (String e : excluded) {
                excludedRelations.add(e);
            }
        }
        for (Map.Entry entry : this.relations.entrySet()) {
            if (excludedRelations.contains(entry.getKey())) continue;
            if (!this.ordering.containsKey(entry.getKey())) {
                this.dropdownData.put((String)entry.getKey() + "List", this.getPersistenceService().findAllBy("from " + this.relations.get(entry.getKey()).getSimpleName(), new Object[0]));
                continue;
            }
            this.dropdownData.put((String)entry.getKey() + "List", this.getPersistenceService().findAllBy("from " + this.relations.get(entry.getKey()).getSimpleName() + " order by " + this.ordering.get(entry.getKey()), new Object[0]));
        }
    }

    protected void addRelatedEntity(String name, Class type) {
        this.relations.put(name, type);
    }

    protected void addRelatedEntity(String name, Class type, String order) {
        this.relations.put(name, type);
        this.ordering.put(name, order);
    }

    protected void addDropdownData(String name, List values) {
        this.dropdownData.put(name, values);
    }

    public boolean acceptableParameterName(String paramName) {
        return !this.relations.containsKey(paramName);
    }

    public void setParameters(Map<String, String[]> parameters) {
        this.parameters = parameters;
    }

    public Map<String, String> getOrdering() {
        return this.ordering;
    }

    public String tokenName() {
        return ((Object)((Object)this)).getClass().getSimpleName() + UUID.randomUUID();
    }
}

