/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.displaytag.export;

import java.io.OutputStream;
import java.io.StringReader;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.jsp.JspException;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;
import org.displaytag.Messages;
import org.displaytag.exception.BaseNestableJspTagException;
import org.displaytag.exception.SeverityEnum;
import org.displaytag.export.BinaryExportView;
import org.displaytag.export.excel.ExcelHssfView;
import org.displaytag.model.Column;
import org.displaytag.model.ColumnIterator;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.Row;
import org.displaytag.model.RowIterator;
import org.displaytag.model.TableModel;
import org.egov.infra.web.displaytag.export.MyHtmlParser;

public class EGovExcelReadOnlyView
implements BinaryExportView {
    private TableModel model;
    private boolean exportFull;
    private boolean header;
    private boolean decorated;
    private HSSFSheet sheet;

    public void setParameters(TableModel tableModel, boolean exportFullList, boolean includeHeader, boolean decorateValues) {
        this.model = tableModel;
        this.exportFull = exportFullList;
        this.header = includeHeader;
        this.decorated = decorateValues;
    }

    public String getMimeType() {
        return "application/vnd.ms-excel";
    }

    public void doExport(OutputStream out) throws JspException {
        try {
            HSSFCell cell;
            HSSFWorkbook wb = new HSSFWorkbook();
            wb.writeProtectWorkbook("egov", "egov");
            this.sheet = wb.createSheet("-");
            int rowNum = 0;
            int colNum = 0;
            if (this.header) {
                HSSFRow xlsRow = this.sheet.createRow(rowNum++);
                HSSFCellStyle headerStyle = wb.createCellStyle();
                headerStyle.setFillPattern((short)2);
                headerStyle.setFillBackgroundColor((short)54);
                HSSFFont bold = wb.createFont();
                bold.setBoldweight((short)700);
                bold.setColor((short)9);
                headerStyle.setFont(bold);
                for (HeaderCell headerCell : this.model.getHeaderCellList()) {
                    String columnHeader = headerCell.getTitle();
                    if (columnHeader == null) {
                        columnHeader = StringUtils.capitalize((String)headerCell.getBeanPropertyName());
                    }
                    cell = xlsRow.createCell(colNum++);
                    cell.setCellValue((RichTextString)this.escapeColumnValue(columnHeader));
                    cell.setCellStyle(headerStyle);
                }
            }
            RowIterator rowIterator = this.model.getRowIterator(this.exportFull);
            while (rowIterator.hasNext()) {
                Row row = rowIterator.next();
                HSSFRow xlsRow = this.sheet.createRow(rowNum++);
                colNum = 0;
                ColumnIterator columnIterator = row.getColumnIterator(this.model.getHeaderCellList());
                while (columnIterator.hasNext()) {
                    Column column = columnIterator.nextColumn();
                    Object value = column.getValue(this.decorated);
                    cell = xlsRow.createCell(colNum++);
                    if (value instanceof Number) {
                        Number num = (Number)value;
                        cell.setCellValue(num.doubleValue());
                        continue;
                    }
                    if (value instanceof Date) {
                        cell.setCellValue((Date)value);
                        continue;
                    }
                    if (value instanceof Calendar) {
                        cell.setCellValue((Calendar)value);
                        continue;
                    }
                    cell.setCellValue((RichTextString)this.escapeColumnValue(value));
                }
            }
            for (int i = 0; i < colNum; i = (int)((short)(i + 1))) {
                this.sheet.autoSizeColumn(i, true);
            }
            wb.write(out);
        }
        catch (Exception e) {
            throw new ExcelGenerationException(e);
        }
    }

    protected HSSFRichTextString escapeColumnValue(Object rawValue) {
        if (rawValue == null) {
            return null;
        }
        String returnString = ObjectUtils.toString((Object)rawValue);
        returnString = StringEscapeUtils.escapeJava((String)StringUtils.trimToEmpty((String)returnString));
        returnString = StringUtils.replace((String)StringUtils.trim((String)returnString), (String)"\\t", (String)"    ");
        returnString = StringUtils.replace((String)StringUtils.trim((String)returnString), (String)"\\r", (String)" ");
        returnString = StringEscapeUtils.unescapeJava((String)returnString);
        returnString = this.removeHtmlTagsAndSpaces(returnString);
        return new HSSFRichTextString(returnString);
    }

    private String removeHtmlTagsAndSpaces(String strValue) {
        String returnValue = null;
        if (strValue != null) {
            StringReader strReader = new StringReader(strValue);
            MyHtmlParser parser = new MyHtmlParser();
            returnValue = parser.parseMyHtml(strReader, true);
        }
        return returnValue;
    }

    static class ExcelGenerationException
    extends BaseNestableJspTagException {
        private static final long serialVersionUID = 899149338534L;

        public ExcelGenerationException(Throwable cause) {
            super(ExcelHssfView.class, Messages.getString((String)"ExcelView.errorexporting"), cause);
        }

        public SeverityEnum getSeverity() {
            return SeverityEnum.ERROR;
        }
    }
}

