/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.security.utils;

import java.util.Optional;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.security.authentication.SecureUser;
import org.egov.infra.persistence.entity.enums.UserType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class SecurityUtils {
    private static final long ANONYMOUS_USER_ID = 2L;
    @Autowired
    private UserService userService;

    public User getCurrentUser() {
        if (SecurityUtils.isCurrentUserAuthenticated()) {
            if (SecurityUtils.isCurrentUserAnonymous()) {
                return this.userService.getUserById(2L);
            }
            return this.userService.getUserById(((SecureUser)SecurityUtils.getCurrentAuthentication().get().getPrincipal()).getUserId());
        }
        return this.userService.getUserById(2L);
    }

    public UserType currentUserType() {
        return ((SecureUser)SecurityUtils.getCurrentAuthentication().get().getPrincipal()).getUserType();
    }

    public static boolean isCurrentUserAuthenticated() {
        Optional<Authentication> authentication = SecurityUtils.getCurrentAuthentication();
        return authentication.isPresent() && authentication.get().isAuthenticated();
    }

    public static boolean isCurrentUserAnonymous() {
        return SecurityUtils.getCurrentAuthentication().get().getPrincipal() instanceof String;
    }

    public static Optional<Authentication> getCurrentAuthentication() {
        return Optional.ofNullable(SecurityContextHolder.getContext().getAuthentication());
    }

    public boolean hasRole(String role) {
        return SecurityUtils.getCurrentAuthentication().get().getAuthorities().parallelStream().map(grantedAuthority -> grantedAuthority.getAuthority().equals(role)).findFirst().get();
    }
}

