/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.reporting.engine;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.infra.cache.impl.LRUCache;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.reporting.util.ReportUtil;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReportService<T>
implements ReportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractReportService.class);
    private LRUCache<String, T> templateCache;
    @PersistenceContext
    private EntityManager entityManager;

    public AbstractReportService(int templateCacheMinSize, int templateCacheMaxSize) {
        this.templateCache = new LRUCache(templateCacheMinSize, templateCacheMaxSize);
    }

    protected abstract ReportOutput createReportFromJavaBean(ReportRequest var1);

    protected abstract ReportOutput createReportFromSql(ReportRequest var1, Connection var2);

    protected abstract ReportOutput createReportFromHql(ReportRequest var1);

    protected abstract String getTemplateExtension();

    protected abstract T loadTemplate(InputStream var1);

    @Override
    public ReportOutput createReport(ReportRequest reportInput) {
        switch (reportInput.getReportDataSourceType()) {
            case JAVABEAN: {
                return this.createReportFromJavaBean(reportInput);
            }
            case SQL: {
                return this.createReportFromSql(reportInput);
            }
            case HQL: {
                return this.createReportFromHql(reportInput);
            }
        }
        throw new ApplicationRuntimeException("Invalid report data source type [" + (Object)((Object)reportInput.getReportDataSourceType()) + "]");
    }

    protected ReportOutput createReportFromSql(ReportRequest reportInput) {
        JdbcReportWork reportWork = new JdbcReportWork(reportInput);
        ((Session)this.entityManager.unwrap(Session.class)).doWork((Work)reportWork);
        return reportWork.getReportOutput();
    }

    protected T getTemplate(String templateName) {
        Object reportTemplate = this.templateCache.get(ApplicationThreadLocals.getTenantID() + templateName);
        if (reportTemplate == null) {
            try {
                reportTemplate = this.loadTemplate(ReportUtil.getTemplateAsStream(templateName + this.getTemplateExtension()));
                this.templateCache.put(ApplicationThreadLocals.getTenantID() + templateName, reportTemplate);
                if (reportTemplate == null) {
                    String errMsg = "Report template [" + templateName + "] could not be loaded";
                    LOGGER.error(errMsg);
                    throw new ApplicationRuntimeException(errMsg);
                }
            }
            catch (ApplicationRuntimeException e) {
                String errMsg = "Exception in getting report template [" + templateName + "]";
                LOGGER.error(errMsg, (Throwable)e);
                throw new ApplicationRuntimeException(errMsg, e);
            }
        }
        return (T)reportTemplate;
    }

    @Override
    public boolean isValidTemplate(String templateName) {
        Object report = null;
        try {
            report = this.getTemplate(templateName);
        }
        catch (Exception e) {
            LOGGER.error(templateName + " is not a valid template name.", (Throwable)e);
        }
        return report != null;
    }

    private class JdbcReportWork
    implements Work {
        private ReportRequest reportInput;
        private ReportOutput reportOutput;

        JdbcReportWork(ReportRequest reportInput) {
            this.reportInput = reportInput;
        }

        public ReportOutput getReportOutput() {
            return this.reportOutput;
        }

        public void execute(Connection connection) throws SQLException {
            this.reportOutput = AbstractReportService.this.createReportFromSql(this.reportInput, connection);
        }
    }
}

