/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.elasticsearch.entity.es;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.Date;
import org.egov.infra.elasticsearch.entity.enums.ClosureStatus;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldIndex;
import org.springframework.data.elasticsearch.annotations.FieldType;

@Document(indexName="applications", type="applications")
public class ApplicationDocument {
    @Id
    private String id;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String moduleName;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String applicationNumber;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timezone="IST")
    @Field(type=FieldType.Date, format=DateFormat.date_optional_time, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private Date applicationDate;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String applicationType;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String applicantName;
    @Field(type=FieldType.String)
    private String applicantAddress;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timezone="IST")
    @Field(type=FieldType.Date, format=DateFormat.date_optional_time, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private Date disposalDate;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String status;
    @Field(type=FieldType.String)
    private String url;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String consumerCode;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String mobileNumber;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String ownerName;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String aadharNumber;
    @Field(type=FieldType.Integer)
    private Integer elapsedDays;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String closed;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String approved;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String channel;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String cityCode;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String cityName;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String cityGrade;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String districtName;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String regionName;
    @Field(type=FieldType.Integer)
    private Integer isClosed;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timezone="IST")
    @Field(type=FieldType.Date, format=DateFormat.date_optional_time, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private Date createdDate;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getApplicationNumber() {
        return this.applicationNumber;
    }

    public void setApplicationNumber(String applicationNumber) {
        this.applicationNumber = applicationNumber;
    }

    public Date getApplicationDate() {
        return this.applicationDate;
    }

    public void setApplicationDate(Date applicationDate) {
        this.applicationDate = applicationDate;
    }

    public String getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(String applicationType) {
        this.applicationType = applicationType;
    }

    public String getApplicantName() {
        return this.applicantName;
    }

    public void setApplicantName(String applicantName) {
        this.applicantName = applicantName;
    }

    public String getApplicantAddress() {
        return this.applicantAddress;
    }

    public void setApplicantAddress(String applicantAddress) {
        this.applicantAddress = applicantAddress;
    }

    public Date getDisposalDate() {
        return this.disposalDate;
    }

    public void setDisposalDate(Date disposalDate) {
        this.disposalDate = disposalDate;
    }

    public String getCityName() {
        return this.cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getDistrictName() {
        return this.districtName;
    }

    public void setDistrictName(String districtName) {
        this.districtName = districtName;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getConsumerCode() {
        return this.consumerCode;
    }

    public void setConsumerCode(String consumerCode) {
        this.consumerCode = consumerCode;
    }

    public String getMobileNumber() {
        return this.mobileNumber;
    }

    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public void setIsClosed(Integer isClosed) {
        this.isClosed = isClosed;
    }

    public String getAadharNumber() {
        return this.aadharNumber;
    }

    public void setAadharNumber(String aadharNumber) {
        this.aadharNumber = aadharNumber;
    }

    public Integer getElapsedDays() {
        return this.elapsedDays;
    }

    public void setElapsedDays(Integer elapsedDays) {
        this.elapsedDays = elapsedDays;
    }

    public String getClosed() {
        return this.closed;
    }

    public void setClosed(String closed) {
        this.closed = closed;
        this.isClosed = this.closed.equals(ClosureStatus.YES.toString()) ? Integer.valueOf(0) : Integer.valueOf(1);
    }

    public String getApproved() {
        return this.approved;
    }

    public void setApproved(String approved) {
        this.approved = approved;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getCityCode() {
        return this.cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public Integer getIsClosed() {
        return this.isClosed;
    }

    public String getCityGrade() {
        return this.cityGrade;
    }

    public void setCityGrade(String cityGrade) {
        this.cityGrade = cityGrade;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }
}

