/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.persistence.multitenancy;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.hibernate.service.spi.Stoppable;

public class TenantDatasourceProvider
implements Stoppable {
    private static final String ANY_DS_JNDI_NAME = "ezgovDatabasePool";
    private Map<String, DataSource> tenantDatasourceStore = new ConcurrentHashMap<String, DataSource>();

    protected DataSource getAnyDataSource() {
        return this.getTenantDataSource(ANY_DS_JNDI_NAME);
    }

    protected DataSource getTenantDataSource(String tenantID) {
        DataSource datasource = this.tenantDatasourceStore.get(tenantID);
        if (datasource == null) {
            try {
                datasource = (DataSource)InitialContext.doLookup("java:/" + tenantID);
            }
            catch (NamingException e) {
                new ApplicationRuntimeException("Error occurred at JNDI lookup for tenant datatsource", e);
            }
            this.tenantDatasourceStore.put(tenantID, datasource);
        }
        return datasource;
    }

    public void stop() {
        this.tenantDatasourceStore.clear();
        this.tenantDatasourceStore = null;
    }
}

