/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.mapper;

import javax.annotation.PostConstruct;
import ma.glasnost.orika.Converter;
import ma.glasnost.orika.DefaultFieldMapper;
import ma.glasnost.orika.Mapper;
import ma.glasnost.orika.MapperFactory;
import ma.glasnost.orika.impl.ConfigurableMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class BeanMapperConfiguration
extends ConfigurableMapper {
    private MapperFactory factory;
    @Autowired
    private ApplicationContext applicationContext;

    public BeanMapperConfiguration() {
        super(false);
    }

    protected void configure(MapperFactory factory) {
        this.factory = factory;
        this.registerBeanMappers();
    }

    private void addMapper(Mapper<?, ?> mapper) {
        this.factory.classMap(mapper.getAType(), mapper.getBType()).byDefault(new DefaultFieldMapper[0]).customize(mapper).register();
    }

    private void addConverter(Converter<?, ?> converter) {
        this.factory.getConverterFactory().registerConverter(converter);
    }

    private void registerBeanMappers() {
        this.applicationContext.getBeansOfType(Mapper.class).values().parallelStream().forEach(this::addMapper);
        this.applicationContext.getBeansOfType(Converter.class).values().parallelStream().forEach(this::addConverter);
    }

    @PostConstruct
    public void initialize() {
        super.init();
    }
}

