/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.elasticsearch;

import java.net.InetSocketAddress;
import org.egov.infra.config.properties.ApplicationProperties;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.repository.config.EnableElasticsearchRepositories;

@Configuration
@EnableElasticsearchRepositories(basePackages={"org.egov.**.repository.es"})
public class ElasticSearchConfiguration {
    @Autowired
    private ApplicationProperties applicationProperties;

    private Client transportClient() {
        Settings settings = Settings.settingsBuilder().put("cluster.name", this.applicationProperties.searchClusterName()).build();
        TransportClient client = TransportClient.builder().settings(settings).build();
        this.applicationProperties.searchHosts().forEach(arg_0 -> this.lambda$transportClient$0((Client)client, arg_0));
        return client;
    }

    @Bean
    public ElasticsearchOperations elasticsearchTemplate() {
        return new ElasticsearchTemplate(this.transportClient());
    }

    private /* synthetic */ void lambda$transportClient$0(Client client, String host) {
        ((TransportClient)client).addTransportAddress((TransportAddress)new InetSocketTransportAddress(new InetSocketAddress(host, this.applicationProperties.searchPort())));
    }
}

