/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.service;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.egov.infra.admin.master.entity.Location;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.repository.LocationRepository;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.properties.ApplicationProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class LocationService {
    private final LocationRepository locationRepository;
    @Autowired
    private UserService userService;
    @Autowired
    private ApplicationProperties applicationProperties;

    @Autowired
    public LocationService(LocationRepository locationRepository) {
        this.locationRepository = locationRepository;
    }

    public List<Location> getActiveLocations() {
        return this.locationRepository.findByActiveTrue();
    }

    public Location getLocation(Long id) {
        return (Location)this.locationRepository.getOne(id);
    }

    public List<Location> getLocationRequiredByUserName(String username) {
        User user = this.userService.getUserByUsername(username);
        boolean userRequiredLocation = false;
        if (user != null) {
            List<String> configuredUserRoles = Arrays.asList(this.applicationProperties.getProperty("location.user.role").split(","));
            for (Role role : user.getRoles()) {
                if (!configuredUserRoles.contains(role.getName())) continue;
                userRequiredLocation = true;
                break;
            }
        }
        return userRequiredLocation ? this.getActiveLocations() : Collections.emptyList();
    }
}

