/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infstr.security.spring.dao;

import java.util.HashMap;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.egov.infra.security.audit.entity.LoginAttempt;
import org.egov.infra.security.audit.service.LoginAttemptService;
import org.egov.infra.security.utils.RecaptchaUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class EgovDaoAuthenticationProvider
extends DaoAuthenticationProvider {
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private LoginAttemptService loginAttemptService;
    @Autowired
    private RecaptchaUtils recaptchaUtils;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        try {
            return super.authenticate(authentication);
        }
        catch (BadCredentialsException e) {
            Optional<LoginAttempt> loginAttempt = this.loginAttemptService.updateFailedAttempt(authentication.getName());
            if (loginAttempt.isPresent()) {
                if (loginAttempt.get().getFailedAttempts() == 5) {
                    throw new LockedException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.locked", "User account is locked"));
                }
                if (loginAttempt.get().getFailedAttempts() > 2) {
                    String message = "Too many attempts [" + (5 - loginAttempt.get().getFailedAttempts()) + "]";
                    throw new BadCredentialsException(message);
                }
            }
            throw e;
        }
        catch (LockedException le) {
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
            HttpServletRequest request = attributes.getRequest();
            if (request.getParameter("g-recaptcha-response") != null || request.getParameter("recaptcha_response_field") != null) {
                if (this.recaptchaUtils.captchaIsValid(request)) {
                    this.loginAttemptService.resetFailedAttempt(authentication.getName());
                    return super.authenticate(authentication);
                }
                throw new LockedException(le.getMessage() + " - Recaptcha Invalid");
            }
            throw le;
        }
    }

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        HashMap authenticationCredentials = (HashMap)authentication.getCredentials();
        if (authentication.getCredentials() == null) {
            throw new BadCredentialsException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.badCredentials", "Bad credentials"));
        }
        String presentedPassword = (String)authenticationCredentials.get("j_password");
        if (!this.passwordEncoder.matches((CharSequence)presentedPassword, userDetails.getPassword())) {
            throw new BadCredentialsException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.badCredentials", "Bad credentials"));
        }
    }
}

