/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.workflow.matrix.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.EgwStatus;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.workflow.entity.WorkflowTypes;
import org.egov.infra.workflow.matrix.entity.WorkFlowAdditionalRule;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrixDetails;
import org.egov.infra.workflow.matrix.repository.WorkflowMatrixRepository;
import org.egov.infra.workflow.service.WorkflowTypeService;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Designation;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class WorkFlowMatrixService {
    public static final String OBJECTTYPE = "ObjectType";
    public static final String ADDITIONALRULE = "AdditionalRule";
    public static final String FROMDATE = "FromDate";
    public static final String TODATE = "ToDate";
    public static final String FROMAMOUNT = "FromAmount";
    public static final String TOAMOUNT = "ToAmount";
    public static final String DEPARTMENTS = "Departments";
    public static final String MODIFYDATE = "ModifyDate";
    public static final String DEFAULT = "DEFAULT";
    public static final String REJECTED = "Rejected";
    public static final String TO_DATE = "toDate";
    public static final String TO_QTY = "toQty";
    public static final String FROM_QTY = "fromQty";
    public static final String FROM_DATE = "fromDate";
    public static final String ADDITIONAL_RULE = "additionalRule";
    public static final String DEPARTMENT = "department";
    public static final String OBJECT_TYPE = "objectType";
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    @Qualifier(value="entityQueryService")
    private PersistenceService entityQueryService;
    @Autowired
    private WorkflowTypeService workflowTypeService;
    @Autowired
    private WorkflowMatrixRepository workflowMatrixRepository;

    public List<Department> getdepartmentList() {
        return this.departmentService.getAllDepartments();
    }

    public List<WorkflowTypes> getobjectTypeList() {
        return this.workflowTypeService.getAllWorkflowTypes();
    }

    public WorkflowTypes getobjectTypebyId(Long objectTypeId) {
        return this.workflowTypeService.getWorkflowTypeById(objectTypeId);
    }

    public WorkflowTypes getobjectTypebyName(String objectTypeName) {
        return this.workflowTypeService.getWorkflowTypeByType(objectTypeName);
    }

    public List getAdditionalRulesforObject(Long objectTypeid) {
        Criteria crit = this.entityQueryService.getSession().createCriteria(WorkFlowAdditionalRule.class);
        crit.add((Criterion)Restrictions.eq((String)"objecttypeid.id", (Object)objectTypeid));
        return crit.list();
    }

    public List<Designation> getdesignationList() {
        return this.entityQueryService.findAllBy("from Designation order by name asc", new Object[0]);
    }

    public Map<String, List> getDetailsforObject(Long workFlowObjectId) {
        ArrayList<String> stateList = new ArrayList<String>();
        ArrayList<String> statusList = new ArrayList<String>();
        ArrayList<String> buttonList = new ArrayList<String>();
        ArrayList<String> objactionList = new ArrayList<String>();
        HashMap<String, List> detailMap = new HashMap<String, List>();
        Criteria stateCrit = this.entityQueryService.getSession().createCriteria(WorkFlowAdditionalRule.class);
        stateCrit.add((Criterion)Restrictions.eq((String)"objecttypeid.id", (Object)workFlowObjectId));
        List workFlowAdditionalList = stateCrit.list();
        for (WorkFlowAdditionalRule wfAdditionalrule : workFlowAdditionalList) {
            StringTokenizer strngtkn;
            if (wfAdditionalrule != null && wfAdditionalrule.getStates() != null && wfAdditionalrule.getStates() != "") {
                strngtkn = new StringTokenizer(wfAdditionalrule.getStates(), ",");
                while (strngtkn.hasMoreTokens()) {
                    String statetkn = strngtkn.nextToken();
                    if (stateList.contains(statetkn)) continue;
                    stateList.add(statetkn);
                }
            }
            if (wfAdditionalrule != null && wfAdditionalrule.getStatus() != null && wfAdditionalrule.getStatus() != "") {
                strngtkn = new StringTokenizer(wfAdditionalrule.getStatus(), ",");
                while (strngtkn.hasMoreTokens()) {
                    String moduleType = strngtkn.nextToken();
                    List statusLists = this.entityQueryService.findAllBy("from EgwStatus where moduletype=? order by code asc", moduleType);
                    for (EgwStatus status : statusLists) {
                        if (status == null || status.getCode() == null || statusList.contains(status.getCode())) continue;
                        statusList.add(status.getCode());
                    }
                }
            }
            if (wfAdditionalrule != null && wfAdditionalrule.getButtons() != null && wfAdditionalrule.getButtons() != "") {
                StringTokenizer btntkn = new StringTokenizer(wfAdditionalrule.getButtons(), ",");
                while (btntkn.hasMoreTokens()) {
                    String buttontkn = btntkn.nextToken();
                    if (buttonList.contains(buttontkn)) continue;
                    buttonList.add(buttontkn);
                }
            }
            if (wfAdditionalrule == null || wfAdditionalrule.getWorkFlowActions() == null || wfAdditionalrule.getWorkFlowActions() == "") continue;
            StringTokenizer acttkn = new StringTokenizer(wfAdditionalrule.getWorkFlowActions(), ",");
            while (acttkn.hasMoreTokens()) {
                String objactiontkn = acttkn.nextToken();
                if (objactionList.contains(objactiontkn)) continue;
                objactionList.add(objactiontkn);
            }
        }
        if (stateList.isEmpty()) {
            stateList.add("Created");
            stateList.add("Checked");
            stateList.add("Approved");
            stateList.add("Inspected");
            stateList.add("Submitted");
            stateList.add("ReSubmitted");
            stateList.add(REJECTED);
        }
        if (statusList.isEmpty()) {
            statusList.add("Created");
            statusList.add("Approved");
            statusList.add(REJECTED);
            statusList.add("Submitted");
            statusList.add("Closed");
        }
        if (buttonList.isEmpty()) {
            buttonList.add("Forward");
            buttonList.add("Approve");
            buttonList.add("Reject");
            buttonList.add("Close");
        }
        if (objactionList.isEmpty()) {
            objactionList.add("Pending Check");
            objactionList.add("Pending Approval");
            objactionList.add("Pending Close");
            objactionList.add("END");
        }
        detailMap.put("StateList", stateList);
        detailMap.put("StatusList", statusList);
        detailMap.put("ButtonsList", buttonList);
        detailMap.put("ActionsList", objactionList);
        return detailMap;
    }

    @Transactional
    public void save(List<WorkFlowMatrix> actualWorkFlowMatrixDetails, String[] departments) {
        for (String dept : departments) {
            for (WorkFlowMatrix workFlowMatrix : actualWorkFlowMatrixDetails) {
                WorkFlowMatrix wfObj = workFlowMatrix.clone();
                if (dept.equals(DEFAULT)) {
                    wfObj.setDepartment("ANY");
                } else {
                    wfObj.setDepartment(dept);
                }
                this.workflowMatrixRepository.save(wfObj);
            }
        }
    }

    public List<WorkFlowMatrixDetails> getWorkFlowMatrixObjectForView(Map workFlowObjectMap) {
        Criteria workFlowCrit = this.entityQueryService.getSession().createCriteria(WorkFlowMatrix.class);
        if (workFlowObjectMap.get(OBJECTTYPE) != null && workFlowObjectMap.get(OBJECTTYPE) != "-1") {
            workFlowCrit.add((Criterion)Restrictions.eq((String)OBJECT_TYPE, (Object)this.getobjectTypebyId((Long)workFlowObjectMap.get(OBJECTTYPE)).getType()));
        }
        if (!"-1".equals(workFlowObjectMap.get(DEPARTMENTS))) {
            String[] department = (String[])workFlowObjectMap.get(DEPARTMENTS);
            workFlowCrit.add((Criterion)Restrictions.eq((String)DEPARTMENT, (Object)department[0]));
        }
        if (!"-1".equals(workFlowObjectMap.get(ADDITIONALRULE))) {
            workFlowCrit.add((Criterion)Restrictions.eq((String)ADDITIONAL_RULE, workFlowObjectMap.get(ADDITIONALRULE)));
        }
        this.addProjectionsforCriteria(workFlowCrit);
        workFlowCrit.addOrder(Order.asc((String)FROM_DATE));
        workFlowCrit.addOrder(Order.asc((String)FROM_QTY));
        workFlowCrit.addOrder(Order.asc((String)ADDITIONAL_RULE));
        workFlowCrit.setResultTransformer(Transformers.aliasToBean(WorkFlowMatrixDetails.class));
        List workFlowList = workFlowCrit.list();
        if (!workFlowList.isEmpty()) {
            List<WorkFlowMatrixDetails> actList = this.checkWithOtherParams(workFlowList, workFlowObjectMap);
            return this.prepareWorkFlowResult(actList);
        }
        return Collections.emptyList();
    }

    private void addProjectionsforCriteria(Criteria workFlowCrit) {
        workFlowCrit.setProjection((Projection)Projections.projectionList().add(Projections.groupProperty((String)OBJECT_TYPE).as("objectTypeAlias")).add(Projections.groupProperty((String)DEPARTMENT).as("departmentAlias")).add(Projections.groupProperty((String)ADDITIONAL_RULE).as("additionalRuleAlias")).add(Projections.groupProperty((String)FROM_QTY).as("fromQtyAlias")).add(Projections.groupProperty((String)TO_QTY).as("toQtyAlias")).add(Projections.groupProperty((String)FROM_DATE).as("fromDateAlias")).add(Projections.groupProperty((String)TO_DATE).as("toDateAlias")));
    }

    private List<WorkFlowMatrixDetails> prepareWorkFlowResult(List<WorkFlowMatrixDetails> matrixdetList) {
        for (WorkFlowMatrixDetails det : matrixdetList) {
            det.setObjectTypeDisplay(this.getobjectTypebyName(det.getObjectType()).getDisplayName());
            List<WorkFlowMatrix> workFlowdet = this.getMatrixdetails(det);
            List<WorkFlowMatrixDetails> detailsList = new LinkedList<WorkFlowMatrixDetails>();
            detailsList = this.prepareWorkFlowMatrixDetailsList(this.sortListbyActions(workFlowdet), detailsList, Boolean.TRUE);
            det.setMatrixdetails(detailsList);
        }
        return matrixdetList;
    }

    public List prepareWorkFlowMatrixDetailsList(List<WorkFlowMatrix> workFlowdet, List<WorkFlowMatrixDetails> detailsList, Boolean isReject) {
        for (WorkFlowMatrix wfMatrixObj : workFlowdet) {
            String[] desnarr;
            String[] buttonarr;
            WorkFlowMatrixDetails details = new WorkFlowMatrixDetails();
            if (isReject.booleanValue()) {
                details.setAction(wfMatrixObj.getNextAction());
                details.setState(wfMatrixObj.getNextState());
                details.setStatus(wfMatrixObj.getNextStatus());
                buttonarr = new String[]{""};
                if (wfMatrixObj.getValidActions() != null) {
                    buttonarr = wfMatrixObj.getValidActions().split(",");
                }
                details.setButtons(buttonarr);
                desnarr = new String[]{""};
                if (wfMatrixObj.getNextDesignation() != null) {
                    desnarr = wfMatrixObj.getNextDesignation().split(",");
                }
                details.setDesignation(desnarr);
                details.setStatus(wfMatrixObj.getNextStatus());
            } else {
                details.setRejectAction(wfMatrixObj.getNextAction());
                details.setRejectState(wfMatrixObj.getNextState());
                details.setRejectStatus(wfMatrixObj.getNextStatus());
                buttonarr = new String[]{""};
                if (wfMatrixObj.getValidActions() != null) {
                    buttonarr = wfMatrixObj.getValidActions().split(",");
                }
                details.setRejectButtons(buttonarr);
                desnarr = new String[]{""};
                if (wfMatrixObj.getNextDesignation() != null) {
                    desnarr = wfMatrixObj.getNextDesignation().split(",");
                }
                details.setRejectDesignation(desnarr);
                details.setRejectStatus(wfMatrixObj.getNextStatus());
            }
            detailsList.add(details);
        }
        return detailsList;
    }

    private List sortListbyActions(List<WorkFlowMatrix> workFlowdet) {
        LinkedList<WorkFlowMatrix> unsortedList = new LinkedList<WorkFlowMatrix>(workFlowdet);
        WorkFlowMatrix rejectedMatrix = null;
        LinkedList<WorkFlowMatrix> workflowSortedList = new LinkedList<WorkFlowMatrix>();
        LinkedList<WorkFlowMatrix> rejectedRelatedList = new LinkedList<WorkFlowMatrix>();
        Iterator<WorkFlowMatrix> workFlowdetiterator = workFlowdet.iterator();
        while (workFlowdetiterator.hasNext()) {
            WorkFlowMatrix wfMatrix = workFlowdetiterator.next();
            if (wfMatrix.getPendingActions() != null || !"NEW".equalsIgnoreCase(wfMatrix.getCurrentState())) continue;
            workflowSortedList.add(wfMatrix);
            workFlowdetiterator.remove();
        }
        Boolean isworkFlowCorrect = Boolean.TRUE;
        while (!workflowSortedList.isEmpty() && !"END".equalsIgnoreCase(((WorkFlowMatrix)workflowSortedList.get(workflowSortedList.size() - 1)).getNextAction())) {
            int size = workFlowdet.size();
            String sortedwfMatrixnextAction = ((WorkFlowMatrix)workflowSortedList.get(workflowSortedList.size() - 1)).getNextAction();
            String sortedwfMatrixnextState = ((WorkFlowMatrix)workflowSortedList.get(workflowSortedList.size() - 1)).getNextState();
            int count = 0;
            for (WorkFlowMatrix wfMatrix : workFlowdet) {
                if (sortedwfMatrixnextAction.equalsIgnoreCase(wfMatrix.getPendingActions()) && sortedwfMatrixnextState.equalsIgnoreCase(wfMatrix.getCurrentState())) {
                    workflowSortedList.add(wfMatrix);
                    continue;
                }
                if (++count < size) continue;
                isworkFlowCorrect = Boolean.FALSE;
                break;
            }
            if (!isworkFlowCorrect.booleanValue()) break;
            for (int j = 0; j < workFlowdet.size(); ++j) {
                Long actwfMatrixnextAction = workFlowdet.get(j).getId();
                for (WorkFlowMatrix wfMatrix : workflowSortedList) {
                    if (!actwfMatrixnextAction.equals(wfMatrix.getId())) continue;
                    workFlowdet.remove(j);
                }
            }
        }
        if (isworkFlowCorrect.booleanValue()) {
            Iterator<WorkFlowMatrix> rejectworkFlowdetiterator = workFlowdet.iterator();
            while (rejectworkFlowdetiterator.hasNext()) {
                WorkFlowMatrix wfMatrix = rejectworkFlowdetiterator.next();
                if (!wfMatrix.getCurrentState().equalsIgnoreCase(REJECTED)) continue;
                rejectedMatrix = wfMatrix;
                for (WorkFlowMatrix wfmatrix : workFlowdet) {
                    if (!wfMatrix.getNextAction().equalsIgnoreCase(wfmatrix.getPendingActions()) || !wfMatrix.getNextState().equalsIgnoreCase(wfmatrix.getCurrentState())) continue;
                    rejectedRelatedList.add(wfmatrix);
                }
                rejectworkFlowdetiterator.remove();
            }
            if (rejectedMatrix != null) {
                workflowSortedList.add(rejectedMatrix);
            }
            for (WorkFlowMatrix wfMatrix : rejectedRelatedList) {
                if (wfMatrix == null || workflowSortedList.contains(wfMatrix)) continue;
                workflowSortedList.add(wfMatrix);
            }
            return workflowSortedList;
        }
        return unsortedList;
    }

    private List<WorkFlowMatrix> getMatrixdetails(WorkFlowMatrixDetails det) {
        Criteria workFlowCrit = this.entityQueryService.getSession().createCriteria(WorkFlowMatrix.class);
        if (det.getObjectType() != null) {
            workFlowCrit.add((Criterion)Restrictions.eq((String)OBJECT_TYPE, (Object)det.getObjectType()));
        }
        if (det.getAdditionalRule() != null) {
            workFlowCrit.add((Criterion)Restrictions.eq((String)ADDITIONAL_RULE, (Object)det.getAdditionalRule()));
        } else {
            workFlowCrit.add(Restrictions.isNull((String)ADDITIONAL_RULE));
        }
        if (det.getDepartment() != null) {
            workFlowCrit.add((Criterion)Restrictions.eq((String)DEPARTMENT, (Object)det.getDepartment()));
        }
        if (det.getFromDate() != null) {
            workFlowCrit.add((Criterion)Restrictions.eq((String)FROM_DATE, (Object)det.getFromDate()));
        }
        if (det.getToDate() != null) {
            workFlowCrit.add((Criterion)Restrictions.eq((String)TO_DATE, (Object)det.getToDate()));
        } else {
            workFlowCrit.add(Restrictions.isNull((String)TO_DATE));
        }
        if (det.getFromQty() != null) {
            workFlowCrit.add((Criterion)Restrictions.eq((String)FROM_QTY, (Object)det.getFromQty()));
        } else {
            workFlowCrit.add(Restrictions.isNull((String)FROM_QTY));
        }
        if (det.getToQty() != null) {
            workFlowCrit.add((Criterion)Restrictions.eq((String)TO_QTY, (Object)det.getToQty()));
        } else {
            workFlowCrit.add(Restrictions.isNull((String)TO_QTY));
        }
        return workFlowCrit.list();
    }

    private List<WorkFlowMatrixDetails> checkWithOtherParams(List<WorkFlowMatrixDetails> workFlowList, Map workFlowObjectMap) {
        Iterator matrixiterator;
        WorkFlowMatrixDetails matrixdet2;
        ArrayList<WorkFlowMatrixDetails> tempList1 = new ArrayList<WorkFlowMatrixDetails>();
        Date fromdate = null;
        Date todate = null;
        BigDecimal fromqty = null;
        BigDecimal toqty = null;
        if (workFlowObjectMap.get(FROMDATE) != null && workFlowObjectMap.get(FROMDATE) != "") {
            fromdate = (Date)workFlowObjectMap.get(FROMDATE);
        }
        if (workFlowObjectMap.get(TODATE) != null && workFlowObjectMap.get(TODATE) != "") {
            todate = (Date)workFlowObjectMap.get(TODATE);
        }
        if (workFlowObjectMap.get(FROMAMOUNT) != null && workFlowObjectMap.get(FROMAMOUNT) != "") {
            fromqty = (BigDecimal)workFlowObjectMap.get(FROMAMOUNT);
        }
        if (workFlowObjectMap.get(TOAMOUNT) != null && workFlowObjectMap.get(TOAMOUNT) != "") {
            toqty = (BigDecimal)workFlowObjectMap.get(TOAMOUNT);
        }
        if (fromdate != null && todate == null) {
            for (WorkFlowMatrixDetails matrixdet2 : workFlowList) {
                if (!this.checkFromDateIsNotBeforeMatrixDate(fromdate, matrixdet2) && !fromdate.before(matrixdet2.getFromDate()) && !fromdate.equals(matrixdet2.getFromDate())) continue;
                tempList1.add(matrixdet2);
            }
        }
        if (fromdate != null && todate != null) {
            for (WorkFlowMatrixDetails matrixdet2 : workFlowList) {
                if (!fromdate.before(matrixdet2.getFromDate()) && !fromdate.equals(matrixdet2.getFromDate()) || !todate.after(matrixdet2.getToDate()) && !todate.equals(matrixdet2.getToDate())) continue;
                tempList1.add(matrixdet2);
            }
        }
        if (fromdate == null && todate == null) {
            tempList1.addAll(workFlowList);
        }
        if (fromqty != null && toqty == null) {
            matrixiterator = tempList1.iterator();
            while (matrixiterator.hasNext()) {
                matrixdet2 = (WorkFlowMatrixDetails)matrixiterator.next();
                if (matrixdet2.getFromQty() != null && (matrixdet2.getFromQty() == null || fromqty.compareTo(matrixdet2.getFromQty()) <= 0)) continue;
                matrixiterator.remove();
            }
        } else if (fromqty != null && toqty != null) {
            matrixiterator = tempList1.iterator();
            while (matrixiterator.hasNext()) {
                matrixdet2 = (WorkFlowMatrixDetails)matrixiterator.next();
                if (matrixdet2.getFromQty() == null || matrixdet2.getToQty() == null) {
                    matrixiterator.remove();
                    continue;
                }
                if (matrixdet2.getToQty() != null && fromqty.doubleValue() >= matrixdet2.getFromQty().doubleValue() && toqty.doubleValue() <= matrixdet2.getToQty().doubleValue()) continue;
                matrixiterator.remove();
            }
        } else if (fromqty == null && toqty != null) {
            matrixiterator = tempList1.iterator();
            while (matrixiterator.hasNext()) {
                matrixdet2 = (WorkFlowMatrixDetails)matrixiterator.next();
                if (matrixdet2.getFromQty() == null) {
                    matrixiterator.remove();
                }
                if (matrixdet2.getToQty() != null) {
                    if (toqty.compareTo(matrixdet2.getToQty()) >= 0) continue;
                    matrixiterator.remove();
                    continue;
                }
                if (toqty.compareTo(matrixdet2.getFromQty()) >= 0) continue;
                matrixiterator.remove();
            }
        }
        if (fromqty == null && toqty == null && fromdate == null && todate == null) {
            return workFlowList;
        }
        return tempList1;
    }

    private boolean checkFromDateIsNotBeforeMatrixDate(Date fromdate, WorkFlowMatrixDetails matrixdet) {
        return matrixdet.getToDate() == null && matrixdet.getFromDate() != null && !fromdate.before(matrixdet.getFromDate());
    }

    public List checkIfMatrixExists(Map workflowheaderparams) {
        StringBuilder dateQryStr = new StringBuilder();
        StringBuilder qntyQryStr = new StringBuilder();
        this.prepareQuery(workflowheaderparams, dateQryStr);
        this.prepareQuery(workflowheaderparams, qntyQryStr);
        dateQryStr.append(" having  fromDate <= :fromdate  and toDate is null ");
        dateQryStr.append(" or fromDate <= :fromdate  and toDate>= :fromdate   ");
        if (StringUtils.isNotBlank((CharSequence)((String)workflowheaderparams.get(TODATE)))) {
            dateQryStr.append(" or fromDate <= :todate  and toDate>= :todate   ");
        }
        Query datequery = this.entityQueryService.getSession().createQuery(new String(dateQryStr));
        this.addParameter(workflowheaderparams, datequery);
        datequery.setParameter("fromdate", workflowheaderparams.get(FROMDATE));
        if (StringUtils.isNotBlank((CharSequence)((String)workflowheaderparams.get(TODATE)))) {
            datequery.setParameter("todate", workflowheaderparams.get(TODATE));
        }
        if (StringUtils.isNotBlank((CharSequence)((String)workflowheaderparams.get(FROMAMOUNT)))) {
            qntyQryStr.append(" having  fromQty <= :fromamount  and toQty is null ");
            qntyQryStr.append(" or fromQty <= :fromamount  and toQty>= :fromamount   ");
        }
        if (StringUtils.isNotBlank((CharSequence)((String)workflowheaderparams.get(TOAMOUNT)))) {
            qntyQryStr.append(" or fromQty <= :toamount  and toQty>= :toamount   ");
        }
        Query qntyquery = this.entityQueryService.getSession().createQuery(new String(qntyQryStr));
        this.addParameter(workflowheaderparams, qntyquery);
        if (StringUtils.isNotBlank((CharSequence)((String)workflowheaderparams.get(FROMAMOUNT)))) {
            qntyquery.setParameter("fromamount", workflowheaderparams.get(FROMAMOUNT));
        }
        if (StringUtils.isNotBlank((CharSequence)((String)workflowheaderparams.get(TOAMOUNT)))) {
            qntyquery.setParameter("toamount", workflowheaderparams.get(TOAMOUNT));
        }
        return qntyquery.list();
    }

    private void prepareQuery(Map workflowheaderparams, StringBuilder qryStr) {
        qryStr.append("select id from  WorkFlowMatrix  where objectType = :objecttype and department IN (:departments) ");
        if (!"-1".equals(workflowheaderparams.get(ADDITIONALRULE))) {
            qryStr.append("and additionalRule = :additionalrule");
        }
        qryStr.append(" group by id,objectType,department,fromDate,toDate,fromQty,toQty ");
        if (!"-1".equals(workflowheaderparams.get(ADDITIONALRULE))) {
            qryStr.append(",additionalRule ");
        }
    }

    private void addParameter(Map workflowheaderparams, Query datequery) {
        datequery.setParameter(OBJECT_TYPE, (Object)this.getobjectTypebyId((Long)workflowheaderparams.get(OBJECTTYPE)).getType());
        if (!"-1".equals(workflowheaderparams.get(ADDITIONALRULE))) {
            datequery.setParameter("additionalrule", workflowheaderparams.get(ADDITIONALRULE));
        }
        datequery.setParameterList("departments", (Object[])((String[])workflowheaderparams.get(DEPARTMENTS)));
    }

    @Transactional
    public void deleteWorkFlowforObject(Map workflowsearchparams) {
        Criteria workFlowCrit = this.getCriteriaForDeleteorModify(workflowsearchparams);
        for (WorkFlowMatrix matrix : workFlowCrit.list()) {
            this.workflowMatrixRepository.delete(matrix);
        }
    }

    public List getWorkFlowforObjectforModify(Map workflowsearchparams) {
        Criteria workFlowCrit = this.getCriteriaForDeleteorModify(workflowsearchparams);
        List matrixList = workFlowCrit.list();
        return this.sortListbyActions(matrixList);
    }

    private Criteria getCriteriaForDeleteorModify(Map workflowsearchparams) {
        Criteria workFlowCrit = this.entityQueryService.getSession().createCriteria(WorkFlowMatrix.class);
        if (StringUtils.isNotBlank((CharSequence)((String)workflowsearchparams.get(OBJECTTYPE)))) {
            workFlowCrit.add((Criterion)Restrictions.eq((String)OBJECT_TYPE, workflowsearchparams.get(OBJECTTYPE)));
        }
        if (StringUtils.isNotBlank((CharSequence)((String)workflowsearchparams.get(ADDITIONALRULE))) && !"-1".equals(workflowsearchparams.get(ADDITIONALRULE))) {
            workFlowCrit.add((Criterion)Restrictions.eq((String)ADDITIONAL_RULE, workflowsearchparams.get(ADDITIONALRULE)));
        }
        if (StringUtils.isNotBlank((CharSequence)((String)workflowsearchparams.get(DEPARTMENTS)))) {
            String[] department = (String[])workflowsearchparams.get(DEPARTMENTS);
            workFlowCrit.add((Criterion)Restrictions.eq((String)DEPARTMENT, (Object)department[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)((String)workflowsearchparams.get(FROMDATE)))) {
            workFlowCrit.add((Criterion)Restrictions.eq((String)FROM_DATE, workflowsearchparams.get(FROMDATE)));
        }
        if (StringUtils.isNotBlank((CharSequence)((String)workflowsearchparams.get(TODATE)))) {
            workFlowCrit.add((Criterion)Restrictions.eq((String)TO_DATE, workflowsearchparams.get(TODATE)));
        }
        if (StringUtils.isNotBlank((CharSequence)((String)workflowsearchparams.get(FROMAMOUNT)))) {
            workFlowCrit.add((Criterion)Restrictions.eq((String)FROM_QTY, workflowsearchparams.get(FROMAMOUNT)));
        }
        if (StringUtils.isNotBlank((CharSequence)((String)workflowsearchparams.get(TOAMOUNT)))) {
            workFlowCrit.add((Criterion)Restrictions.eq((String)TO_QTY, workflowsearchparams.get(TOAMOUNT)));
        }
        return workFlowCrit;
    }

    @Transactional
    public Boolean updateWorkFlowforObject(Map workflowparams) {
        Criteria workFlowCrit = this.getCriteriaForDeleteorModify(workflowparams);
        Iterator iterator = workFlowCrit.list().iterator();
        while (iterator.hasNext()) {
            WorkFlowMatrix matrix;
            matrix.setToDate((matrix = (WorkFlowMatrix)iterator.next()).getToDate() != null ? matrix.getToDate() : (workflowparams.get(MODIFYDATE) != null ? (Date)workflowparams.get(MODIFYDATE) : new Date()));
            if (matrix.getFromDate().equals(matrix.getToDate())) {
                return false;
            }
            this.workflowMatrixRepository.save(matrix);
        }
        return true;
    }

    public Date checkLegacyMatrix(Map workflowheaderparams) {
        Criteria workFlowCrit = this.entityQueryService.getSession().createCriteria(WorkFlowMatrix.class);
        if (StringUtils.isNotBlank((CharSequence)((String)workflowheaderparams.get(OBJECTTYPE)))) {
            workFlowCrit.add((Criterion)Restrictions.eq((String)OBJECT_TYPE, (Object)this.getobjectTypebyId((Long)workflowheaderparams.get(OBJECTTYPE)).getType()));
        }
        if (!"-1".equals(workflowheaderparams.get(ADDITIONALRULE))) {
            workFlowCrit.add((Criterion)Restrictions.eq((String)ADDITIONAL_RULE, workflowheaderparams.get(ADDITIONALRULE)));
        }
        if (!"-1".equals(workflowheaderparams.get(DEPARTMENTS))) {
            String[] department = (String[])workflowheaderparams.get(DEPARTMENTS);
            workFlowCrit.add((Criterion)Restrictions.eq((String)DEPARTMENT, (Object)department[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)((String)workflowheaderparams.get(FROMDATE)))) {
            workFlowCrit.add((Criterion)Restrictions.ge((String)FROM_DATE, workflowheaderparams.get(FROMDATE)));
        }
        if (StringUtils.isNotBlank((CharSequence)((String)workflowheaderparams.get(FROMAMOUNT)))) {
            workFlowCrit.add((Criterion)Restrictions.eq((String)FROM_QTY, workflowheaderparams.get(FROMAMOUNT)));
        }
        if (StringUtils.isNotBlank((CharSequence)((String)workflowheaderparams.get(TOAMOUNT)))) {
            workFlowCrit.add((Criterion)Restrictions.eq((String)TO_QTY, workflowheaderparams.get(TOAMOUNT)));
        }
        this.addProjectionsforCriteria(workFlowCrit);
        workFlowCrit.addOrder(Order.asc((String)TO_DATE));
        workFlowCrit.setResultTransformer(Transformers.aliasToBean(WorkFlowMatrixDetails.class));
        List matrixList = workFlowCrit.list();
        if (!matrixList.isEmpty()) {
            return ((WorkFlowMatrixDetails)matrixList.get(0)).getFromDateAlias();
        }
        return null;
    }

    public WorkFlowMatrix getWorkFlowObjectbyId(Long matrixid) {
        return (WorkFlowMatrix)this.workflowMatrixRepository.findOne(matrixid);
    }
}

